/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.nestedlevelcalculation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.nestedlevelcalculation.Util;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class FlagNestedLevelCalcs
extends Transformation {
    public FlagNestedLevelCalcs() {
        this.mName = "Flag nested level calcs.";
        this.mPassNumbers = new int[]{24};
        this.mTypes = new int[]{1013};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        MDXCalculatedMemberDefinition calcDef = calcRef.getDefinition();
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery.getCalcMemberRefForDefinition(calcDef).size() > 1) {
            calcDef = (MDXCalculatedMemberDefinition)MDXBuilder.deepCopyExcludingCMDefs(factory, calcDef, false);
            mdxQuery.addChild(calcDef, 0);
            calcRef.bind(calcDef);
        }
        calcRef.setPropertyValue("originalHierarchy", calcRef.getHierarchy());
        calcRef.getDefinition().setIsNestedLevelCalc(true);
        calcRef.setIsNestedLevelCalcRef(true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        if (calcRef.getDefinition().isNestedLevelCalc()) {
            this.traceNodeCondition(false, "The expression is already flagged as a nested level calculation.", trace);
            return false;
        }
        StringBuilder sb = new StringBuilder();
        if (!Util.isNestedLevelCalculation(calcRef, sb)) {
            this.traceNodeCondition(false, sb.toString(), trace);
            return false;
        }
        this.traceNodeCondition(true, sb.toString(), trace);
        return true;
    }
}

