/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.nestedlevelcalculation;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCurrentMember;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.nestedlevelcalculation.Util;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;

public final class MoveNestedLevelCalculation
extends Transformation {
    public MoveNestedLevelCalculation() {
        this.mName = "Move nested level calculations to a different hierarchy.";
        this.mPassNumbers = new int[]{24};
        this.mTypes = new int[]{1013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXEdge mdxEdge;
        XQENodeFactory factory = environment.getNodeFactory();
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        IXQEQueryNode parent = calcRef.getParent();
        IHierarchy hierarchy = Util.getHierarchyToMoveTheCalculationTo(calcRef);
        CogMDXGroup originalCogMDXGroup = (CogMDXGroup)calcRef.getAncestorOfCategory(1027);
        if (originalCogMDXGroup != null && (mdxEdge = (MDXEdge)originalCogMDXGroup.getAncestorOfCategory(1006)) != null && mdxEdge.isProjectedDescendant(originalCogMDXGroup) && ((AbstractMDXSet)originalCogMDXGroup.getChild(0)).isProjectedDescendant(calcRef)) {
            calcRef.setOriginalGroupForNLC(originalCogMDXGroup);
        }
        if (parent.getType() == 1069) {
            this.replaceDefaultMember(parent, calcRef, factory, hierarchy);
        } else {
            AbstractMDXSet ancestorSet = Util.getAncestorSetForMovingTheCalculationToDiffHierarchy(calcRef);
            this.addToOtherGroupNodes(ancestorSet, calcRef, factory, hierarchy);
        }
    }

    private void addToOtherGroupNodes(IXQEQueryNode group, MDXCalculatedMemberReference calcRef, IXQENodeFactory factory, IHierarchy hierarchy) {
        IXQEQueryNode child;
        if (group.getType() == 1030) {
            group = group.getParent();
        }
        if ((child = group.getNumberChildren() == 1 ? group.getChild(0) : group.getChild(1)).getType() == 1027) {
            this.addToOtherGroupNodes(child, calcRef, factory, hierarchy);
            ((CogMDXGroup)child).setSetNLCFillerMember(calcRef);
        } else if (child.getType() == 1039 && child.getNumberChildren() == 1 && child.getChild(0).isOfCategory(1077) && ((MDXDefaultMember)child.getChild(0)).getPropertyIsNoMember() && ((MDXDefaultMember)child.getChild(0)).getHierarchy() == hierarchy) {
            this.replaceDefaultMember(child.getChild(0), calcRef, factory, hierarchy);
        } else if (child.getType() == 1039) {
            for (int setIndex = 0; setIndex < child.getNumberChildren(); ++setIndex) {
                IXQEQueryNode setChild = child.getChild(setIndex);
                if (setChild.isOfCategory(1077) || setChild.isOfCategory(1069)) {
                    this.replaceDefaultMember(setChild, calcRef, factory, hierarchy);
                    continue;
                }
                if (setChild.isOfCategory(1027)) {
                    this.addToOtherGroupNodes((CogMDXGroup)setChild, calcRef, factory, hierarchy);
                    continue;
                }
                if (setChild.getType() == 1042 || setChild.getType() == 1083) {
                    this.addToOtherGroupNodes(setChild.getChild(0), calcRef, factory, hierarchy);
                    continue;
                }
                if (setChild.getType() == 1004) continue;
                calcRef.throwInternalError("Error");
            }
        }
    }

    private void replaceDefaultMember(IXQEQueryNode node, MDXCalculatedMemberReference calcRef, IXQENodeFactory factory, IHierarchy hierarchy) {
        int i;
        if (node.isOfCategory(1077) && ((MDXDefaultMember)node).getPropertyIsNoMember()) {
            IXQEQueryNode tuple = factory.createNode(1069);
            node.insertParent(tuple);
            node = tuple;
        }
        if (node.getType() != 1069) {
            node.throwInternalError("Unable to move the nested level calculation.");
        }
        boolean lockeTNodeAddMemberToContext = false;
        for (i = 0; i < node.getNumberChildren(); ++i) {
            if (!node.getChild(i).isOfCategory(1077) || !((MDXDefaultMember)node.getChild(i)).getPropertyIsNoMember() || ((MDXDefaultMember)node.getChild(i)).getHierarchy() != hierarchy) continue;
            MDXDefaultMember defaultMember = (MDXDefaultMember)node.getChild(i);
            MDXDefaultMember defaultMemberToAddToContext = (MDXDefaultMember)factory.deepCopyNode(defaultMember);
            MDXCurrentMember newCurrentMember = MDXBuilder.buildMDXCurrentMemberExpr(factory, calcRef.getHierarchy());
            calcRef.getDefinition().setHierarchy(defaultMember.getHierarchy());
            MDXBuilder.insertTNodeAddMemberToContext(factory, (AbstractMDXNode)calcRef.getDefinition().getChild(0), defaultMemberToAddToContext);
            lockeTNodeAddMemberToContext = true;
            MDXCalculatedMemberReference newCalcRef = MDXBuilder.duplicateCalcReference(calcRef, factory);
            node.exchangeChildNode(defaultMember, newCalcRef, false);
            if (calcRef.getParent() != null) {
                calcRef.getParent().exchangeChildNode(calcRef, newCurrentMember, false);
            }
            calcRef.getDefinition().setIsNestedLevelCalc(false);
            break;
        }
        if (i == node.getNumberChildren()) {
            node.throwInternalError("Could not find the default member to move the calculation to." + hierarchy);
        }
        int tnodeType = 1126;
        if (lockeTNodeAddMemberToContext && !calcRef.getPlanningEnvironment().getLockNodeQueryPlanningEnabled() && calcRef.getPlanningEnvironment().getLockNodeType() != tnodeType) {
            calcRef.getPlanningEnvironment().enableLockNodeQueryPlanning(tnodeType);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        if (!calcRef.getDefinition().isNestedLevelCalc()) {
            this.traceNodeCondition(false, "The calculated member is not a grouped nested level expression.", trace);
            return false;
        }
        if (Util.getHierarchyToMoveTheCalculationTo(calcRef) == null) {
            StringBuilder errMsg = new StringBuilder("There is no default member on a different hierarchy ");
            errMsg.append("to move the calculated member to.");
            this.traceNodeCondition(false, errMsg.toString(), trace);
            return false;
        }
        this.traceNodeCondition(true, "The nested level calculation can be moved to a different hierarchy.", trace);
        return true;
    }
}

