/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.nestedlevelcalculation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSetAliasDefinition;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.transformation.olap.util.MiscellaneousUtilities;
import java.util.List;
import java.util.Set;

public final class Util {
    private Util() {
    }

    public static IHierarchy getHierarchyToMoveTheCalculationTo(MDXCalculatedMemberReference calcRef) {
        block7: {
            AbstractMDXSet ancestorSet;
            block8: {
                IXQEQueryNode parent;
                block6: {
                    parent = calcRef.getParent();
                    if (!parent.isOfCategory(1069)) break block6;
                    for (int i = 0; i < parent.getNumberChildren(); ++i) {
                        if (!parent.getChild(i).isOfCategory(1077) || !((MDXDefaultMember)parent.getChild(i)).getPropertyIsNoMember()) continue;
                        return ((MDXDefaultMember)parent.getChild(i)).getHierarchy();
                    }
                    break block7;
                }
                if (parent.getType() != 1039) break block7;
                if (!Util.isInASetOFCalculations(calcRef) && parent.getNumberChildren() > 1) {
                    return null;
                }
                ancestorSet = Util.getAncestorSetForMovingTheCalculationToDiffHierarchy(calcRef);
                if (ancestorSet == null) {
                    return null;
                }
                if (ancestorSet.getType() != 1030) break block8;
                IXQEQueryNode crossJoin = ancestorSet.getParent();
                if (crossJoin.getType() != 1030) break block7;
                Set<IHierarchy> hierarchies = ((MDXCrossjoin)crossJoin).getReferencedHierarchies();
                for (IHierarchy hier : hierarchies) {
                    if (!Util.canMoveToOtherGroupNodes(crossJoin, hier)) continue;
                    return hier;
                }
                break block7;
            }
            if (ancestorSet.getNumberChildren() == 2 && ((AbstractMDXSet)ancestorSet.getChild(1)).isContextDependent(calcRef.getHierarchy())) {
                return null;
            }
            Set<IHierarchy> hierarchies = ancestorSet.getReferencedHierarchies();
            for (IHierarchy hier : hierarchies) {
                if (!Util.canMoveToOtherGroupNodes(ancestorSet, hier)) continue;
                return hier;
            }
        }
        return null;
    }

    public static AbstractMDXSet getAncestorSetForMovingTheCalculationToDiffHierarchy(AbstractMDXMember aMember) {
        AbstractMDXSet ancestorSet;
        CogMDXGroup calcAncestorGroup = (CogMDXGroup)aMember.getAncestorOfCategory(1027);
        if (calcAncestorGroup == null) {
            return calcAncestorGroup;
        }
        if (calcAncestorGroup.getType() == 1080 && calcAncestorGroup.getNumberChildren() == 1 && (calcAncestorGroup = (CogMDXGroup)calcAncestorGroup.getAncestorOfType(1027)) == null) {
            return calcAncestorGroup;
        }
        AbstractMDXSet groupFirstChild = (AbstractMDXSet)calcAncestorGroup.getChild(0);
        MDXSetAliasDefinition setAliasDefinition = (MDXSetAliasDefinition)calcAncestorGroup.getAncestorOfType(1004);
        if (setAliasDefinition != null) {
            boolean isProj = false;
            MDXEdge edge = (MDXEdge)setAliasDefinition.getAncestorOfType(1006);
            if (edge == null) {
                MDXQuery query = (MDXQuery)setAliasDefinition.getAncestorOfType(1002);
                if (query == null) {
                    setAliasDefinition.throwInternalError("query == null");
                } else {
                    isProj = query.isProjectedDescendant(setAliasDefinition);
                }
            } else {
                isProj = edge.isProjectedDescendant(setAliasDefinition);
            }
            if (!isProj) {
                return null;
            }
        } else if (!groupFirstChild.isProjectedDescendant(aMember)) {
            return null;
        }
        if ((ancestorSet = MiscellaneousUtilities.getOuterSetProjSingleMemberWithinBoundary(groupFirstChild, aMember)) == null) {
            return ancestorSet;
        }
        if (ancestorSet == groupFirstChild) {
            return calcAncestorGroup;
        }
        if (ancestorSet.getParent().getType() == 1030) {
            return (AbstractMDXSet)ancestorSet.getParent();
        }
        return null;
    }

    public static boolean isInASetOFCalculations(AbstractMDXMember aMember) {
        IXQEQueryNode parent = aMember.getParent();
        if (parent.getType() == 1039 && aMember.getType() == 1013) {
            IXQEQueryNode[] setChildren = parent.getChildren();
            if (parent.getNumberChildren() == 1) {
                return false;
            }
            for (IXQEQueryNode currChild : setChildren) {
                if (currChild.getType() == 1013) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean canMoveToOtherGroupNodes(IXQEQueryNode group, IHierarchy hierarchy) {
        IXQEQueryNode child;
        if (group.getNumberChildren() == 1) {
            if (!group.getChild(0).isOfCategory(1039) || group.getChild(0).getNumberChildren() != 1 || !group.getChild(0).getChild(0).isOfCategories(new int[]{1069, 1022})) return false;
            child = group.getChild(0);
        } else {
            child = group.getChild(1);
        }
        if (child.getType() == 1027) {
            return Util.canMoveToOtherGroupNodes((CogMDXGroup)child, hierarchy);
        }
        if (child.getType() == 1039 && child.getNumberChildren() == 1 && child.getChild(0).isOfCategory(1077)) {
            return ((MDXDefaultMember)child.getChild(0)).getHierarchy() == hierarchy && ((MDXDefaultMember)child.getChild(0)).getPropertyIsNoMember();
        }
        if (child.getType() != 1039) return false;
        for (int setIndex = 0; setIndex < child.getNumberChildren(); ++setIndex) {
            IXQEQueryNode setChild = child.getChild(setIndex);
            if (setChild.isOfCategory(1077) && ((MDXDefaultMember)setChild).getPropertyIsNoMember() && ((MDXDefaultMember)setChild).getHierarchy() == hierarchy) continue;
            if (setChild.isOfCategory(1069)) {
                IXQEQueryNode tupleChild;
                int tupleIndex;
                for (tupleIndex = 0; !(tupleIndex >= setChild.getNumberChildren() || (tupleChild = setChild.getChild(tupleIndex)).isOfCategory(1077) && ((MDXDefaultMember)tupleChild).getPropertyIsNoMember() && ((MDXDefaultMember)tupleChild).getHierarchy() == hierarchy); ++tupleIndex) {
                }
                if (tupleIndex != setChild.getNumberChildren()) continue;
                return false;
            }
            if (!(setChild.getType() == 1042 || setChild.getType() == 1083 ? !Util.canMoveToOtherGroupNodes((CogMDXGroup)setChild.getChild(0), hierarchy) : setChild.getType() != 1004 && (!setChild.isOfCategory(1027) || !Util.canMoveToOtherGroupNodes((CogMDXGroup)setChild, hierarchy)))) continue;
            return false;
        }
        return true;
    }

    public static boolean projectesNLC(AbstractMDXNode root) {
        List<AbstractMDXNode> calcMembers = root.getDescendantsOfCategory(1013, false, false, true, true, false);
        for (int calcIndex = 0; calcIndex < calcMembers.size(); ++calcIndex) {
            MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)calcMembers.get(calcIndex);
            if (!calcRef.getDefinition().isNestedLevelCalc() || !root.isProjectedDescendant(calcRef)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNestedExprDependentOnCalc(MDXCalculatedMemberReference calcRef) {
        IXQEQueryNode parent;
        for (parent = calcRef.getParent(); parent != null && parent.getType() != 1027; parent = parent.getParent()) {
            if (parent.isOfCategory(1021) && parent.getParent() != null && parent.getParent().getPositionOfChild(parent) == 0) continue;
            return false;
        }
        if (parent == null) {
            return false;
        }
        if (parent.getNumberChildren() != 2) {
            return false;
        }
        AbstractMDXNode secondChild = (AbstractMDXNode)parent.getChild(1);
        return secondChild.isContextDependent(calcRef.getHierarchy());
    }

    public static boolean isNestedLevelCalculation(MDXCalculatedMemberReference calcRef, StringBuilder msgStr) {
        IXQEQueryNode parent;
        IHierarchy calcHier;
        if (calcRef == null || msgStr == null) {
            throw new IllegalArgumentException();
        }
        if (calcRef.getDefinition().isNestedLevelCalc()) {
            msgStr.append("The expression is already flagged as a nested level calculation.");
            return true;
        }
        MDXEdge edge = (MDXEdge)calcRef.getAncestorOfType(1006);
        if (edge != null) {
            edge.throwOnInvalidChildCategories();
            if (!((AbstractMDXSet)edge.getChild(0)).isProjectedDescendant(calcRef)) {
                msgStr.append("The calculated member is not projected on the edge.");
                return false;
            }
        }
        if ((calcHier = calcRef.getHierarchy()).getDimension().isMeasuresDimension()) {
            msgStr.append("The calculated member is defined in the measure dimension.");
            return false;
        }
        if (!calcRef.getDefinition().isContextDependent(calcHier)) {
            boolean contextDependent = false;
            List<AbstractMDXNode> refList = calcRef.getDefinition().getDescendantsOfCategory(1013, false, true, false, true, false);
            for (int i = 0; i < refList.size() && !contextDependent; ++i) {
                contextDependent = ((MDXCalculatedMemberReference)refList.get(i)).getDefinition().isContextDependent(calcHier);
            }
            if (!contextDependent) {
                msgStr.append("The calculated member is not dependent on the hierarchy it's defined in.");
                return false;
            }
        }
        IXQEQueryNode child = calcRef;
        MDXQuery mdxQuery = (MDXQuery)calcRef.getAncestorOfType(1002);
        MDXCalculatedMemberReference calcNewRef = calcRef;
        for (parent = calcRef.getParent(); parent != null; parent = parent.getParent()) {
            CogMDXGroup mdxGroupNode;
            List<IXQEQueryNode> refList;
            if (parent.getType() == 1005 && edge == null && (refList = mdxQuery.getCalcMemberRefForDefinition((MDXCalculatedMemberDefinition)parent)).size() == 1) {
                calcNewRef = (MDXCalculatedMemberReference)refList.get(0);
                parent = calcNewRef;
            }
            if (parent.getType() == 1027 && (mdxGroupNode = (CogMDXGroup)parent).getNumberChildren() > 1 && mdxGroupNode.getChild(1) == child) break;
            child = parent;
        }
        if (parent == null) {
            msgStr.append("The calculated member is not part of a nested expression.");
            return false;
        }
        if (!((CogMDXGroup)parent).validateChildCategories()) {
            msgStr.append("The operands of the ancestor CogMDXGroup node are invalid.");
            return false;
        }
        MDXHierInfo contextInfo = ((AbstractMDXSet)parent.getChild(0)).getHierarchyInfo();
        if (!contextInfo.projectsHierarchy(calcHier)) {
            msgStr.append("The calculated member is not part of a grouped nested level expression.");
            return false;
        }
        if (calcNewRef != null) {
            edge = (MDXEdge)calcNewRef.getAncestorOfType(1006);
            if (edge == null) {
                msgStr.append("The top nested calculated member is not on the edge.");
                return false;
            }
            edge.throwOnInvalidChildCategories();
            if (!((AbstractMDXSet)edge.getChild(0)).isProjectedDescendant(calcNewRef)) {
                msgStr.append("The top nested calculated member is not projected on the edge.");
                return false;
            }
        }
        msgStr.append("The calculated member is a grouped nested level expression.");
        return true;
    }
}

