/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.normalization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;

public final class AddDefMemberToContextForHiersProjectedOnOppEdge
extends Transformation {
    public static final String PROPERTY_TRANSFORMATION_APPLIED = "AddDefMemberToContextForHierarchiesProjectedOnOppositeEdgeApplied";

    public AddDefMemberToContextForHiersProjectedOnOppEdge() {
        this.mName = "Add Default Member To Context For Hierarchies Projected On Opposite Edge.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        boolean lockeTNodeAddMemberToContext = false;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXEdge[] edges = mdxQuery.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            MDXHierInfo edgeHierInfo = edges[i].getHierarchyInfo();
            for (int j = 0; j < edgeHierInfo.getNumProjectedHierarchies(); ++j) {
                IHierarchy hierarchy = edgeHierInfo.getProjectedHierarchy(j);
                if (hierarchy.getDimension().isMeasuresDimension()) continue;
                MDXDefaultMember mdxDefaultMember = MDXBuilder.buildMDXDefaultMemberExpr((IXQENodeFactory)factory, hierarchy);
                MDXBuilder.insertTNodeAddMemberToContext(factory, (AbstractMDXSet)node.getChild(0), mdxDefaultMember);
                lockeTNodeAddMemberToContext = true;
            }
        }
        node.setPropertyValue(PROPERTY_TRANSFORMATION_APPLIED, Boolean.TRUE);
        if (lockeTNodeAddMemberToContext) {
            environment.enableLockNodeQueryPlanning(1126);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(PROPERTY_TRANSFORMATION_APPLIED) == Boolean.TRUE) {
            this.traceNodeCondition(false, "The transformation was already applied to this node.", trace);
            return false;
        }
        node.throwOnInvalidChildCategories();
        this.traceNodeCondition(true, "The transformation has not yet been applied to this node.", trace);
        return true;
    }
}

