/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.CMSolveOrderTiesComparator;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class InitializeUnReferencedSolveOrders
extends Transformation {
    public InitializeUnReferencedSolveOrders() {
        this.mName = "Initialize solve orders for calculations not referenced from the query";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{1005};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        SolveOrderUtil.setSolveOrder(node, SolveOrderUtil.getUnreferencedSolveOrder());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (SolveOrderUtil.getSolveOrder(node) == SolveOrderUtil.getUnreferencedSolveOrder()) {
            this.traceNodeCondition(false, "The solve order is already normalized.", trace);
            return false;
        }
        MDXCalculatedMemberDefinition calcDef = (MDXCalculatedMemberDefinition)node;
        if (calcDef.isAbsoluteSolveOrder().booleanValue()) {
            this.traceNodeCondition(false, "The solve order is an absolute solve order.", trace);
            return false;
        }
        if (CMSolveOrderTiesComparator.findCalcRef(calcDef) != null) {
            this.traceNodeCondition(false, "The calculation is referenced from an edge.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The calculation is not referenced from an edge.", trace);
        return true;
    }
}

