/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class PropagateV5SuppressQueryHintToEdges
extends Transformation {
    public PropagateV5SuppressQueryHintToEdges() {
        this.mName = "Propagate the V5 suppress query hint to all edges.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1002};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        if (mdxQuery.isV5QueryHintPropagated()) {
            this.traceNodeCondition(false, "The V5 suppress query has been already propagated.", trace);
            return false;
        }
        if (mdxQuery.isSuppressNullsWithNoMeasure()) {
            this.traceNodeCondition(false, "The mdxQuery does not include any measure: do not apply the V5 suppress.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Propagate the V5 suppress query hint.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node;
        boolean providerSpecificCase = mdxQuery.getSuppressNullsProviderDefault();
        if (mdxQuery.getSuppressNulls() != null || providerSpecificCase) {
            MDXEdge[] mdxEdges;
            for (MDXEdge mdxEdge : mdxEdges = mdxQuery.getEdges()) {
                Boolean suppressNulls = mdxQuery.getSuppressNulls();
                if (suppressNulls == null && providerSpecificCase) {
                    suppressNulls = Boolean.TRUE;
                }
                if (suppressNulls == null) continue;
                mdxEdge.setMDXNonEmptyProperty(suppressNulls);
                if (!Boolean.FALSE.equals(suppressNulls)) continue;
                mdxEdge.setPowerCubeZeroSuppress(suppressNulls);
            }
        }
        mdxQuery.setV5QueryHintPropagated();
    }
}

