/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.CMSolveOrderTiesComparator;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import com.cognos.xqe.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;

public final class ResolveSolveOrderTies
extends Transformation {
    public ResolveSolveOrderTies() {
        this.mName = "Resolve solve order ties.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1005, 1028};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        AbstractMDXNode def;
        int i;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        int[] types = new int[]{1005, 1028};
        IXQEQueryNode[] allDefs = mdxQuery.getDescendantsOfTypes(types, false);
        ArrayList<IXQEQueryNode> sameSOCalcs = new ArrayList<IXQEQueryNode>();
        int solveOrder = SolveOrderUtil.getSolveOrder(node);
        for (int i2 = 0; i2 < allDefs.length; ++i2) {
            IXQEQueryNode compareCalc = allDefs[i2];
            if (SolveOrderUtil.isAbsoluteSolveOrder(compareCalc).booleanValue() || solveOrder != SolveOrderUtil.getSolveOrder(compareCalc) || CMSolveOrderTiesComparator.findCalcRefOnQRD(compareCalc) == null) continue;
            sameSOCalcs.add(compareCalc);
        }
        CMSolveOrderTiesComparator bySO = new CMSolveOrderTiesComparator();
        Object[] sameSODefs = sameSOCalcs.toArray(new IXQEQueryNode[sameSOCalcs.size()]);
        Arrays.sort(sameSODefs, bySO);
        int inc = 0;
        AbstractMDXNode previous = (AbstractMDXNode)sameSODefs[0];
        for (i = 1; i < sameSODefs.length; ++i) {
            def = (AbstractMDXNode)sameSODefs[i];
            if (bySO.compare(previous, def) != 0) {
                previous = def;
                inc += SolveOrderUtil.getIncNormalizedSolveOrder();
            }
            if (inc == 0) continue;
            SolveOrderUtil.setSolveOrder(def, SolveOrderUtil.getSolveOrder(def) + inc);
        }
        for (i = 0; i < allDefs.length; ++i) {
            def = (AbstractMDXNode)allDefs[i];
            if (SolveOrderUtil.isAbsoluteSolveOrder(def).booleanValue() || SolveOrderUtil.getSolveOrder(def) <= solveOrder || ArrayUtil.contains(sameSODefs, def)) continue;
            SolveOrderUtil.setSolveOrder(def, SolveOrderUtil.getSolveOrder(def) + inc);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        int[] types = new int[]{1005, 1028};
        int solveOrder = SolveOrderUtil.getSolveOrder(node);
        if (!mdxQuery.isSolveOrdersNormalized()) {
            this.traceNodeCondition(false, "The solve orders have not been normalized yet.", trace);
            return false;
        }
        if (solveOrder == SolveOrderUtil.getMaxMDXSolveOrder() || solveOrder == SolveOrderUtil.getUndefinedMDXSolveOrder() || SolveOrderUtil.isAbsoluteSolveOrder(node).booleanValue()) {
            this.traceNodeCondition(false, "Solve order ties for the node do not need to be resolved.", trace);
            return false;
        }
        if (CMSolveOrderTiesComparator.findCalcRefOnQRD(node) == null) {
            this.traceNodeCondition(false, "Calculated member is not referenced from an edge.", trace);
            return false;
        }
        CMSolveOrderTiesComparator bySO = new CMSolveOrderTiesComparator();
        IXQEQueryNode[] calcs = mdxQuery.getDescendantsOfTypes(types, false);
        for (int i = 0; i < calcs.length; ++i) {
            IXQEQueryNode compareCalc = calcs[i];
            if (SolveOrderUtil.isAbsoluteSolveOrder(compareCalc).booleanValue() || solveOrder != SolveOrderUtil.getSolveOrder(compareCalc) || CMSolveOrderTiesComparator.findCalcRefOnQRD(compareCalc) == null || bySO.compare(compareCalc, node) == 0) continue;
            this.traceNodeCondition(true, "Another calculated member defined in a different herarchy has the same solve order where ties must be resolved.", trace);
            return true;
        }
        this.traceNodeCondition(false, "No other referenced calculated member has the same solve order where ties must be resolved.", trace);
        return false;
    }

    public IHierarchy getHierarchy(IXQEQueryNode node) {
        MDXHierInfo hierInfo;
        if (node.getType() == 1005) {
            return ((MDXCalculatedMemberDefinition)node).getHierarchy();
        }
        IXQEQueryNode reportSummary = node.getAncestorOfType(1080);
        if (reportSummary != null && (hierInfo = ((CogMDXReportSummary)reportSummary).getHierarchyInfo()) != null && hierInfo.getNumProjectedHierarchies() > 0) {
            return hierInfo.getProjectedHierarchy(0);
        }
        return null;
    }
}

