/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.BaseLevel;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.BaseProperty;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXDescendants;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXHeadTailFunction;
import com.cognos.xqe.ast.olap.MDXNamedSetDefinition;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSetAliasReference;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.olap.MDXTopBottomFunction;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.olap.util.MDXOOMContext;
import com.cognos.xqe.ast.olap.util.MDXOOMInfo;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToMeasureWrapper;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.parameters.RequestParameters;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class IdentifyPushdownCandidate
extends Transformation {
    private static final int MAX_PRECISION = 31;
    public static final String LOCAL_PROCESS_ONLY = "local_process_only";
    public static final String STRING_DMR = "dmr";
    public static final String STRING_DMR_UPPERCASE = "DMR";
    public static final String STR_ERR_1 = "The pushdown target expression containss Aggregate summary function that should be handled by external aggregation.";
    public static final String STR_ERR_2 = "The MDXQuery has a detail filter skipping members.";
    public static final String STR_ERR_3 = "The pushdown target expression contains unsupported expressions. ";

    public IdentifyPushdownCandidate() {
        this.mName = "Push the evaluation of an expression to underlying data source.";
        this.mPassNumbers = new int[]{48};
        this.mTypes = new int[]{1041, 1053, 1042, 1005};
        Arrays.sort(this.mTypes);
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery.isDMRCubeReuseEnabled()) {
            mdxQuery.setDMRCubeReuseEnabled(false);
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode tNode = null;
        if (node.getType() == 1005) {
            tNode = nodeFactory.createNode(1195);
            IXQEQueryNode child = node.getChild(0);
            child.insertParent(tNode);
        } else {
            tNode = nodeFactory.createNode(1191);
            node.insertParent(tNode);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The target node is not a descendant of an MDXQuery node.", trace);
            return false;
        }
        if (!mdxQuery.isDMR()) {
            this.traceNodeCondition(false, "The MDXQuery is NOT a DMR query. ", trace);
            return false;
        }
        if (node.getType() != 1005) {
            return this.passesNodeConditionForCustomSet(node, environment, mdxQuery);
        }
        return this.passesNodeConditionForCustomValue(node, environment, mdxQuery);
    }

    public boolean passesNodeConditionForCustomSet(IXQEQueryNode node, PlanningEnvironment environment, MDXQuery mdxQuery) {
        Governors gv;
        XQETrace trace = environment.getTrace();
        boolean pushdown = false;
        IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities(STRING_DMR_UPPERCASE);
        double levelOOMThreshold = providerCapabilities.getDoubleValue("PushdownThroughCustomSetForLevelOOMLargerThan", 0.0);
        if (levelOOMThreshold > 0.0 && node.getType() == 1042) {
            String queryHint = (String)mdxQuery.getPropertyValue(V5Query.QueryHint.QUERY_INTENT.getPropertyName());
            if (!(mdxQuery.isDMRCubeReuseEnabled() && !"metadata".equals(queryHint) || node.getNumberChildren() >= 2 && node.getChild(1).getType() != 1064)) {
                MDXOOMContext context = new MDXOOMContext(STRING_DMR);
                MDXOOMInfo r = ((AbstractMDXSet)node).computeOOM(context);
                boolean bl = pushdown = r.getOOM() > levelOOMThreshold;
            }
        }
        if (node.getType() == 1042 && IdentifyPushdownCandidate.hasFilterSkippingMembers(mdxQuery)) {
            this.traceNodeCondition(false, STR_ERR_2, trace);
            return false;
        }
        if (!pushdown) {
            if (mdxQuery.isDMRCubeReuseEnabled()) {
                this.traceNodeCondition(false, "Reusable DMR cube does not support CustomSet pushdown.", trace);
                return false;
            }
            pushdown = providerCapabilities.isSupported("enablePushdownThroughCustomSet");
        }
        double checkOOM = 0.0;
        if (!pushdown && (gv = mdxQuery.getGovernors()) != null && (checkOOM = gv.getEnablePushdownLevelOOM()) > 0.0) {
            pushdown = true;
        }
        if (!pushdown) {
            this.traceNodeCondition(false, "Pushdown through CustomSet is not enabled.", trace);
            return false;
        }
        RSAPIDataset dataset = (RSAPIDataset)mdxQuery.getAncestorOfType(401005);
        if (dataset.projectsMeasures()) {
            boolean nonEmpty = true;
            MDXEdge currentEdge = (MDXEdge)node.getAncestorOfType(1006);
            if (currentEdge != null) {
                nonEmpty = currentEdge.getMDXNonEmptyProperty();
            } else {
                for (MDXEdge edge : mdxQuery.getEdges()) {
                    if (edge.getMDXNonEmptyProperty()) continue;
                    nonEmpty = false;
                    break;
                }
            }
            if (!nonEmpty && node.getFirstDescendantOfCategory(1068, false) != null) {
                this.traceNodeCondition(false, "CustomSet pushdown does not support query without Null suppression and tuple context.", trace);
                return false;
            }
        }
        if (!IdentifyPushdownCandidate.isSupportedPushdownTarget(node, this.mTypes)) {
            this.traceNodeCondition(false, "The target node is not supported for pushdown.", trace);
            return false;
        }
        ArrayList<IXQEQueryNode> ancestors = new ArrayList<IXQEQueryNode>();
        IdentifyPushdownCandidate.getAncestorOfTypes(node, new int[]{1191}, ancestors);
        if (!ancestors.isEmpty()) {
            this.traceNodeCondition(false, "the pushdown target node is already part of a pushdown query.", trace);
            return false;
        }
        Pair p = new Pair(this, trace);
        if (IdentifyPushdownCandidate.isValidCustomSetPushdownTarget(environment, node, p, this.mTypes)) {
            MDXOOMContext context;
            MDXOOMInfo r;
            return !(checkOOM > 0.0) || !((r = ((AbstractMDXSet)node).computeOOM(context = new MDXOOMContext(STRING_DMR))).getOOM() <= checkOOM);
        }
        return false;
    }

    public boolean passesNodeConditionForCustomValue(IXQEQueryNode node, PlanningEnvironment environment, MDXQuery mdxQuery) {
        XQETrace trace = environment.getTrace();
        IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities(STRING_DMR_UPPERCASE);
        if (!providerCapabilities.isSupported("pushdownCustomValueToRelational")) {
            this.traceNodeCondition(false, "the pushdown thru CustomValue optimization is not enabled.", trace);
            return false;
        }
        if (node.getPropertyValue(LOCAL_PROCESS_ONLY) != null) {
            this.traceNodeCondition(false, "the pushdown optimization has failed on this node, go back to local process.", trace);
            return false;
        }
        IXQEQueryNode child = node.getChild(0);
        if (child != null && (child.getType() == 1195 || child.getType() == 1196)) {
            this.traceNodeCondition(false, "the pushdown target node is already processed.", trace);
            return false;
        }
        double levelOOMThreshold = providerCapabilities.getDoubleValue("PushdownThroughCustomSetForLevelOOMLargerThan", 0.0);
        List<AbstractMDXNode> descendantsFunctions = ((AbstractMDXNode)node).getDescendantsOfCategories(new int[]{1052}, true, true, true, true, false);
        if (descendantsFunctions.size() == 0) {
            this.traceNodeCondition(false, "There is no Descendants function under the calculated member.", trace);
            return false;
        }
        int[] customSetTypes = new int[]{1191, 1042, 1041, 1053, 1032, 1192, 1005};
        List<AbstractMDXNode> customSetFunctions = ((AbstractMDXNode)node).getDescendantsOfCategories(customSetTypes, true, true, true, true, false);
        if (customSetFunctions.size() > 0) {
            this.traceNodeCondition(false, "Other Pushdown query targets are found in the calculated member", trace);
            return false;
        }
        if (node.getAncestorOfTypes(customSetTypes) != null) {
            this.traceNodeCondition(false, "Nested Pushdown query is not supported", trace);
            return false;
        }
        MDXLevelInfo contextLevelInfo = new MDXLevelInfo();
        MDXHierInfo contextHierarchyInfo = mdxQuery.getHierarchyInfo();
        for (IHierarchy iHierarchy : contextHierarchyInfo.getProjectedHierarchies()) {
            MDXLevelInfo mDXLevelInfo = mdxQuery.getLevelInfo(iHierarchy);
            contextLevelInfo.appendProjectedHierarchy(mDXLevelInfo, iHierarchy);
        }
        boolean pushdown = false;
        for (IXQEQueryNode iXQEQueryNode : descendantsFunctions) {
            if (((MDXDescendants)iXQEQueryNode).getRangeFlag() > 0) {
                this.traceNodeCondition(false, "Descendants function has range option different than SELF,too complex for pushdown", trace);
                return false;
            }
            MDXLevelInfo levelInfo = ((MDXDescendants)iXQEQueryNode).getLevelInfo();
            if (contextLevelInfo.projectedLevelsOverlap(levelInfo)) {
                this.traceNodeCondition(false, "Level of Descendants function is projected, do not need to pushdown", trace);
                return false;
            }
            MDXOOMContext context = new MDXOOMContext(STRING_DMR);
            MDXOOMInfo r = ((AbstractMDXSet)iXQEQueryNode).computeOOM(context);
            pushdown = r.getOOM() > levelOOMThreshold;
        }
        if (!pushdown) {
            this.traceNodeCondition(false, "Level of Descendants function is projected or not a large set of members .", trace);
            return false;
        }
        if (IdentifyPushdownCandidate.hasFilterSkippingMembers(mdxQuery)) {
            this.traceNodeCondition(false, STR_ERR_2, trace);
            return false;
        }
        Pair pair = new Pair(this, trace);
        return IdentifyPushdownCandidate.isValidCustomValuePushdownTarget(node, pair, this.mTypes);
    }

    protected static boolean isValidCustomValuePushdownTarget(IXQEQueryNode node, Pair p, int[] theTypes) {
        IXQEQueryNode[] summaryFunctions;
        for (IXQEQueryNode aSummaryFunction : summaryFunctions = node.getDescendantsOfType(1060, true)) {
            if (((MDXSummaryFunction)aSummaryFunction).getSummaryType() != MDXSummaryFunctionTypeEnum.AGGREGATE) continue;
            IdentifyPushdownCandidate.traceCondition(p, false, STR_ERR_1);
            return false;
        }
        StringBuilder msg = new StringBuilder();
        if (IdentifyPushdownCandidate.containsUnsupportedExpressions((AbstractMDXNode)node, msg, true, theTypes)) {
            IdentifyPushdownCandidate.traceCondition(p, false, STR_ERR_3 + msg.toString());
            return false;
        }
        return true;
    }

    protected static boolean hasFilterSkippingMembers(MDXQuery query) {
        CubeWrapper cube = (CubeWrapper)query.getReferencedCube();
        for (CogMDXDetailFilter detailFilter : cube.getDetailFilters()) {
            if (detailFilter.getPropertyValue("DMRSkipMembers") != Boolean.TRUE) continue;
            return true;
        }
        return false;
    }

    protected static void getAncestorOfTypes(IXQEQueryNode node, int[] types, List<IXQEQueryNode> ancestors) {
        int[] ancestorTypes = Arrays.copyOf(types, types.length + 1);
        ancestorTypes[types.length] = 1003;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IXQEQueryNode ancestorPushdownTarget = node.getAncestorOfTypes(ancestorTypes);
        if (ancestorPushdownTarget != null) {
            if (ancestorPushdownTarget.getType() == 1003) {
                IXQEQueryNode[] namedSetRefs;
                for (IXQEQueryNode aRef : namedSetRefs = mdxQuery.getDescendantsOfType(1014, false)) {
                    IXQEQueryNode aRefAncestor;
                    if (!((MDXNamedSetReference)aRef).getUniqueName().equals(((MDXNamedSetDefinition)ancestorPushdownTarget).getUniqueName()) || (aRefAncestor = aRef.getAncestorOfTypes(ancestorTypes)) == null) continue;
                    if (aRefAncestor.getType() == 1003) {
                        IdentifyPushdownCandidate.getAncestorOfTypes(aRefAncestor, types, ancestors);
                        continue;
                    }
                    ancestors.add(aRefAncestor);
                }
            } else {
                ancestors.add(ancestorPushdownTarget);
            }
        }
    }

    protected static boolean isSupportedPushdownTarget(IXQEQueryNode node, int[] theTypes) {
        boolean result = false;
        if (node.getPropertyValue(LOCAL_PROCESS_ONLY) != null) {
            return result;
        }
        if (Arrays.binarySearch(theTypes, node.getNodeType()) >= 0) {
            int subType;
            result = true;
            if (node.getNodeType() == 1041 && (subType = ((MDXTopBottomFunction)node).getOperatorType()) != 1 && subType != 4) {
                result = false;
            }
        }
        return result;
    }

    protected static void traceCondition(Pair p, boolean b, String msg) {
        if (p == null) {
            return;
        }
        Transformation t = (Transformation)p.getFirst();
        XQETrace trace = (XQETrace)p.getSecond();
        t.traceNodeCondition(b, msg, trace);
    }

    protected static boolean isValidCustomSetPushdownTarget(PlanningEnvironment environment, IXQEQueryNode node, Pair p, int[] theTypes) {
        IXQEQueryNode[] pushdownTargets;
        if (!IdentifyPushdownCandidate.isOperatingOnEntireLevel(node, theTypes)) {
            return false;
        }
        ArrayList<IXQEQueryNode> ancestors = new ArrayList<IXQEQueryNode>();
        int[] mdxCustomSetTypes = new int[]{1041, 1053, 1042};
        IdentifyPushdownCandidate.getAncestorOfTypes(node, mdxCustomSetTypes, ancestors);
        for (IXQEQueryNode iXQEQueryNode : ancestors) {
            if (iXQEQueryNode.getType() == 1087 && ((MDXCount)iXQEQueryNode).getHeadSuppression() || iXQEQueryNode.getType() == 1042 && ((MDXHeadTailFunction)iXQEQueryNode).getHeadSuppression() || iXQEQueryNode == null || !IdentifyPushdownCandidate.isSupportedPushdownTarget(iXQEQueryNode, theTypes) || !IdentifyPushdownCandidate.isValidCustomSetPushdownTarget(environment, iXQEQueryNode, p, theTypes)) continue;
            IdentifyPushdownCandidate.traceCondition(p, false, "Outer pushdown target needs to be processed first.");
            return false;
        }
        List<AbstractMDXNode> summaryFunctions = ((AbstractMDXSet)node).getDescendantsOfType(1060, true, true, true, true, false);
        for (AbstractMDXNode abstractMDXNode : summaryFunctions) {
            if (((MDXSummaryFunction)abstractMDXNode).getSummaryType() == MDXSummaryFunctionTypeEnum.AGGREGATE) {
                IdentifyPushdownCandidate.traceCondition(p, false, STR_ERR_1);
                return false;
            }
            if (abstractMDXNode.getChild(0).getType() != 1041 && abstractMDXNode.getChild(0).getType() != 1042) continue;
            return false;
        }
        List<AbstractMDXNode> list = ((AbstractMDXSet)node).getDescendantsOfType(1087, true, true, true, true, false);
        for (AbstractMDXNode aSummaryFunction : list) {
            if (aSummaryFunction.getChild(0).getType() != 1041 && aSummaryFunction.getChild(0).getType() != 1042) continue;
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (IdentifyPushdownCandidate.containsUnsupportedExpressions((AbstractMDXNode)node, stringBuilder, false, theTypes)) {
            IdentifyPushdownCandidate.traceCondition(p, false, STR_ERR_3 + stringBuilder.toString());
            return false;
        }
        boolean isFilteredByMeasure = false;
        for (IXQEQueryNode target : pushdownTargets = node.getDescendantsOfTypes(theTypes, true)) {
            IXQEQueryNode valueExpression = null;
            if (target.getType() == 1053) {
                valueExpression = target.getChild(1);
            } else if (target.getType() == 1041) {
                valueExpression = target.getChild(2);
            } else if (target.getType() == 1042) {
                isFilteredByMeasure = true;
                break;
            }
            if (valueExpression == null || IdentifyPushdownCandidate.collectFilteringMeasureAndProperty(environment, (AbstractMDXNode)valueExpression).isEmpty()) continue;
            isFilteredByMeasure = true;
            break;
        }
        if (!isFilteredByMeasure) {
            IdentifyPushdownCandidate.traceCondition(p, false, "The pushdown target expression is not filtered by measure. ");
            return false;
        }
        IXQEQueryNode cmAncestor = node.getAncestorOfType(1005);
        if (cmAncestor != null) {
            int solveOrder = ((MDXCalculatedMemberDefinition)cmAncestor).getSolveOrder();
            MDXQuery mdxQuery = (MDXQuery)cmAncestor.getAncestorOfType(1002);
            for (MDXCalculatedMemberDefinition cmDef : mdxQuery.getCalcMemberDefinitions()) {
                if (cmDef == cmAncestor || solveOrder <= cmDef.getSolveOrder()) continue;
                IdentifyPushdownCandidate.traceCondition(p, false, "The pushdown target expression is part of a calculated member that is not at lowest solve order.");
                return false;
            }
        }
        return true;
    }

    protected static List<AbstractMDXNode> collectFilteringMeasureAndProperty(PlanningEnvironment environment, AbstractMDXNode node) {
        ArrayList<AbstractMDXNode> allMeasures = new ArrayList<AbstractMDXNode>();
        int[] measureTypes = new int[]{1067, 1025};
        List<AbstractMDXNode> targets = node.getDescendantsOfTypes(measureTypes, true, true, true, true, false);
        for (IXQEQueryNode iXQEQueryNode : targets) {
            if (iXQEQueryNode.getType() == 1067) {
                if (((BaseMember)iXQEQueryNode).isMeasure()) {
                    if (((BaseMember)iXQEQueryNode).getMember().getAggregateRules().length == 0) {
                        allMeasures.add((AbstractMDXNode)iXQEQueryNode);
                        continue;
                    }
                    return Collections.emptyList();
                }
                if (((BaseMember)iXQEQueryNode).getLevel().getName() != "tagLevelForCompleteTuple") continue;
                return Collections.emptyList();
            }
            if (((BaseProperty)iXQEQueryNode).getPropertyMetadata() != null || ((BaseProperty)iXQEQueryNode).getSupplementaryMetadata() != null) {
                allMeasures.add((AbstractMDXNode)iXQEQueryNode);
                continue;
            }
            if (IdentifyPushdownCandidate.isCaptionProperty(iXQEQueryNode)) {
                allMeasures.add((AbstractMDXNode)iXQEQueryNode);
                continue;
            }
            return Collections.emptyList();
        }
        return allMeasures;
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean containsUnsupportedExpressions(AbstractMDXNode node, StringBuilder msg, boolean customValuePushdown, int[] theTypes) {
        IXQEQueryNode[] unions;
        void var8_13;
        int[] relativeFuncs;
        List<AbstractMDXNode> levels = node.getDescendantsOfType(1065, true, true, true, true, false);
        for (AbstractMDXNode aLevel : levels) {
            if (!(((BaseLevel)aLevel).getLevel() instanceof V5DataItemToLevelWrapper)) continue;
            return true;
        }
        int[] parameterTypes = new int[]{1163, 1162, 1161, 1159, 1129};
        List<AbstractMDXNode> parameters = node.getDescendantsOfCategories(parameterTypes, true, true, true, true, true);
        for (AbstractMDXNode abstractMDXNode : parameters) {
            if (node.getType() == 1129) {
                msg.append("Member parameter is not supported.");
                return true;
            }
            MultiRequestContext multiRequestContext = ExecutionEnvironmentContext.getExecutionEnvironment().getMultiRequestContext();
            RequestParameters requestParameters = multiRequestContext.getRequestParameters();
            IXQEQueryNode[] parameter = requestParameters.getParameters().getParameter(((AbstractMDXValueExpression)abstractMDXNode).getName());
            if (parameter == null || !parameter.isResolved()) {
                return true;
            }
            if (abstractMDXNode.getType() != 1161) continue;
            List<String> values = parameter.getExternalValues(true);
            for (String aValue : values) {
                IXQEQueryNode[] value = new BigDecimal(aValue);
                if (value.precision() <= 31) continue;
                msg.append("Numeric parameter value exceeds maximun precision allowed.");
                return true;
            }
        }
        List<AbstractMDXNode> numericConstants = node.getDescendantsOfType(1064, true, true, true, true, true);
        for (AbstractMDXNode aNConstant : numericConstants) {
            BigDecimal value = new BigDecimal(((MDXNumericConstant)aNConstant).getConstantValue().toString());
            if (value.precision() <= 31) continue;
            msg.append("Numeric constant value exceeds maximun precision allowed.");
            return true;
        }
        Object var8_10 = null;
        if (customValuePushdown) {
            relativeFuncs = new int[]{1034, 1156, 1047, 1051, 1074, 1049, 1050, 1075, 1035, 1147};
            List<AbstractMDXNode> list = node.getDescendantsOfCategories(relativeFuncs, true, true, true, true, true);
        } else {
            relativeFuncs = new int[]{1034, 1156, 1047, 1051, 1074, 1049, 1050, 1075, 1035, 1147, 1192, 1191, 1052, 1038};
            List<AbstractMDXNode> list = node.getDescendantsOfCategories(relativeFuncs, true, true, true, true, true);
        }
        if (!var8_13.isEmpty()) {
            msg.append("Relative MDX functions are not supported.");
            return true;
        }
        ArrayList<IXQEQueryNode> skip = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode union : unions = node.getDescendantsOfType(1039, true)) {
            for (IXQEQueryNode child : union.getChildren()) {
                if (child.getType() == 1067) {
                    skip.add(child);
                    continue;
                }
                msg.append("UNION or Set has non member children is not supported.");
            }
        }
        List<AbstractMDXNode> isEmptyFunctions = node.getDescendantsOfType(1104, true, true, true, true, false);
        for (AbstractMDXNode func : isEmptyFunctions) {
            if (func.getParent().getNodeType() == 1109) continue;
            msg.append("IsEmpty by itself is not supported due to inner join limitation.");
            return true;
        }
        if (!customValuePushdown) {
            List<AbstractMDXNode> topBottomFunctions = node.getDescendantsOfType(1041, true, true, true, true, false);
            for (AbstractMDXNode func : topBottomFunctions) {
                if (IdentifyPushdownCandidate.isSupportedPushdownTarget(func, theTypes)) continue;
                msg.append("Top/Bottom Sum/Percent are not supported");
                return true;
            }
        }
        ArrayList<BaseMember> members = new ArrayList<BaseMember>();
        ArrayList<BaseMember> measures = new ArrayList<BaseMember>();
        int[] measureTypes = new int[]{1067, 1025};
        List<AbstractMDXNode> targets = node.getDescendantsOfTypes(measureTypes, true, true, true, true, false);
        for (IXQEQueryNode iXQEQueryNode : targets) {
            if (skip.contains(iXQEQueryNode)) continue;
            if (iXQEQueryNode.getType() == 1067) {
                if (((BaseMember)iXQEQueryNode).getMember() instanceof V5DataItemToMeasureWrapper) {
                    return true;
                }
                if (((BaseMember)iXQEQueryNode).isMeasure()) {
                    if (((BaseMember)iXQEQueryNode).getMember().getAggregateRules().length != 0) {
                        msg.append("Measure with aggregation rules are not supported.");
                        return true;
                    }
                    measures.add((BaseMember)iXQEQueryNode);
                    continue;
                }
                if (((BaseMember)iXQEQueryNode).getLevel().getName() == "tagLevelForCompleteTuple") {
                    msg.append("Complete tuple is not supported.");
                    return true;
                }
                if (((BaseMember)iXQEQueryNode).isRootMember()) continue;
                boolean bExist = false;
                for (BaseMember aMember : members) {
                    if (!aMember.isSameExpression(iXQEQueryNode, false)) continue;
                    bExist = true;
                    break;
                }
                if (bExist) continue;
                members.add((BaseMember)iXQEQueryNode);
                continue;
            }
            if (((BaseProperty)iXQEQueryNode).getPropertyMetadata() != null || ((BaseProperty)iXQEQueryNode).getSupplementaryMetadata() != null || IdentifyPushdownCandidate.isCaptionProperty(iXQEQueryNode)) continue;
            msg.append("Property can to be associated to modle metadata.");
            return true;
        }
        if (!customValuePushdown && measures.size() > 1) {
            for (BaseMember baseMember : measures) {
                IXQEQueryNode valueAncestor = baseMember.getAncestorOfCategory(1062);
                for (BaseMember aMember : members) {
                    IXQEQueryNode temp = aMember.getAncestorOfCategory(1062);
                    if (valueAncestor == temp) continue;
                    msg.append("Measure are computed in different context.");
                    return true;
                }
            }
        }
        if (customValuePushdown) {
            List<AbstractMDXNode> defaultMembers = node.getDescendantsOfType(1077, true, true, true, true, false);
            for (AbstractMDXNode defMember : defaultMembers) {
                IXQEQueryNode gParent;
                IXQEQueryNode parent = defMember.getParent();
                if (parent == null || parent.getType() != 1069 || (gParent = parent.getParent()) == null || gParent.getType() != 1059) continue;
                msg.append("MDX_Tuple has default member.");
                return true;
            }
        }
        return false;
    }

    protected static boolean isCaptionProperty(IXQEQueryNode aTarget) {
        RoleTypeEnum roleType;
        IHierarchy hierarchy;
        boolean isCaption = false;
        MDXLevelInfo levelInfo = ((AbstractMDXNode)aTarget.getParent()).getLevelInfo();
        if (levelInfo.getHierarchyInfo().getNumProjectedHierarchies() == 1 && levelInfo.getNumProjectedLevels(hierarchy = levelInfo.getHierarchyInfo().getProjectedHierarchy(0)) == 1 && (roleType = (RoleTypeEnum)((Object)aTarget.getPropertyValue("propertyRoleType"))) != null && roleType == RoleTypeEnum.MEMBER_CAPTION) {
            isCaption = true;
        }
        return isCaption;
    }

    protected static boolean isOperatingOnEntireLevel(IXQEQueryNode node, int[] theTypes) {
        IXQEQueryNode setChild = IdentifyPushdownCandidate.getSetChild(node.getChild(0), theTypes);
        if (setChild.getNodeType() == 1040 && setChild.getChild(0).getType() == 1065) {
            return true;
        }
        return setChild.getNodeType() == 1048 && setChild.getChild(0).getType() == 1067;
    }

    public static IXQEQueryNode getSetChild(IXQEQueryNode node, int[] theTypes) {
        boolean updated = false;
        while (node.getType() == 1014) {
            node = ((MDXNamedSetReference)node).getDefinition().getChild(0);
            updated = true;
        }
        while (node.getType() == 1015) {
            node = ((MDXSetAliasReference)node).getDefinition().getChild(0);
            updated = true;
        }
        while (node.getType() == 1004) {
            node = node.getChild(0);
            updated = true;
        }
        while (node.getType() == 1039 && node.getNumberChildren() == 1) {
            node = node.getChild(0);
            updated = true;
        }
        while (theTypes != null && Arrays.binarySearch(theTypes, node.getNodeType()) >= 0) {
            node = node.getChild(0);
            updated = true;
        }
        if (updated) {
            return IdentifyPushdownCandidate.getSetChild(node, theTypes);
        }
        return node;
    }
}

