/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXExcept;
import com.cognos.xqe.ast.olap.MDXIntersect;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class OptimizeDistinctWithinSetOperator
extends Transformation {
    public OptimizeDistinctWithinSetOperator() {
        this.mName = "Remove the disctinct over the set expression when it can be pushed as part of the parent expression.";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{1033};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode set = node.getParent();
        if (set.getType() == 1038) {
            ((MDXIntersect)set).setAll(false);
        } else if (set.getType() == 1032) {
            ((MDXExcept)set).setAll(false);
        }
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child node of the MDXDistinct node is invalid.", trace);
            return false;
        }
        int parentNodeType = node.getParent().getType();
        if (parentNodeType == 1038 || parentNodeType == 1032) {
            if (node.getParent().getChild(0) != node) {
                this.traceNodeCondition(false, "The MDXDistinct operand is not the first operands of an MDXUnion/Intersect/Except expression.", trace);
                return false;
            }
            this.traceNodeCondition(true, "The MDXDistinct operand is an MDXUnion/Intersect/Except expressionthat projects duplicates.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The MDXDistinct operand is not within an MDXUnion/Intersect/Except expression.", trace);
        return false;
    }
}

