/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.TNodeTrueFalse;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;

public final class OptimizeEquivalentComparisons
extends Transformation {
    public OptimizeEquivalentComparisons() {
        this.mName = "Optimize Equivalent Comparisons";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1070};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        boolean isTrue = false;
        isTrue = node.getChild(0).isSameExpression(node.getChild(1), false) ? !this.comparesToFalse(node) : !this.constantComparesToFalse(node);
        TNodeTrueFalse replacementNode = MDXBuilder.buildTNodeTrueFalse(factory, isTrue);
        node.getParent().exchangeChildNode(node, replacementNode, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the target node are invalid.", trace);
            return false;
        }
        if (node.getAncestorOfCategory(1010) == null && node.getAncestorOfCategory(1011) == null) {
            this.traceNodeCondition(false, "The node is not part of a filter.", trace);
            return false;
        }
        if (node.getChild(0).getType() == node.getChild(1).getType()) {
            if (node.getChild(0).isSameExpression(node.getChild(1), false)) {
                this.traceNodeCondition(true, "The comparison expressions are equal.", trace);
                return true;
            }
            if (node.getChild(0).getType() == 1127 && node.getChild(1).getType() == 1127 && ((MDXComparisonOperator)node).getOperatorType() == 1 || ((MDXComparisonOperator)node).getOperatorType() == 2) {
                return true;
            }
        }
        this.traceNodeCondition(false, "The comparison expressions are not equal.", trace);
        return false;
    }

    private boolean constantComparesToFalse(IXQEQueryNode node) {
        boolean comparesToFalse = false;
        IXQEQueryNode node1 = node.getChild(0);
        IXQEQueryNode node2 = node.getChild(1);
        if (node1.isOfCategory(1127) && node2.isOfCategory(1127) && ((MDXComparisonOperator)node).getOperatorType() == 1) {
            comparesToFalse = true;
        }
        return comparesToFalse;
    }

    private boolean comparesToFalse(IXQEQueryNode node) {
        boolean comparesToFalse = false;
        MDXComparisonOperator comparison = (MDXComparisonOperator)node;
        if (comparison.getOperatorType() == 3 || comparison.getOperatorType() == 4 || comparison.getOperatorType() == 2) {
            comparesToFalse = true;
        }
        return comparesToFalse;
    }
}

