/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXHierarchy;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class OptimizeExtractOnCrossjoin
extends Transformation {
    public OptimizeExtractOnCrossjoin(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Optimize Extract On Crossjoin.";
        this.mTypes = new int[]{1106};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXHierInfo extractHierInfo = ((AbstractMDXHierarchy)node.getChild(1)).getHierarchyInfo();
        IHierarchy hierarchy = extractHierInfo.getProjectedHierarchy(0);
        MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)node.getChild(0);
        AbstractMDXSet op1 = (AbstractMDXSet)mdxCrossjoin.getChild(0);
        MDXHierInfo op1HierInfo = op1.getHierarchyInfo();
        if (op1HierInfo.projectsHierarchy(hierarchy)) {
            mdxCrossjoin.detachChild(op1);
            if (op1HierInfo.getNumProjectedHierarchies() > 1) {
                node.exchangeChildNode(mdxCrossjoin, op1);
            } else {
                IXQEQueryNode mdxDistinct = factory.createNode(1033);
                mdxDistinct.addChild(op1);
                node.getParent().exchangeChildNode(node, mdxDistinct);
            }
        } else {
            AbstractMDXSet op2 = (AbstractMDXSet)mdxCrossjoin.getChild(1);
            MDXHierInfo op2HierInfo = op2.getHierarchyInfo();
            mdxCrossjoin.detachChild(op2);
            if (op2HierInfo.getNumProjectedHierarchies() > 1) {
                node.exchangeChildNode(mdxCrossjoin, op2);
            } else {
                IXQEQueryNode mdxDistinct = factory.createNode(1033);
                mdxDistinct.addChild(op2);
                node.getParent().exchangeChildNode(node, mdxDistinct);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        StringBuilder traceMsg = new StringBuilder();
        boolean result = OptimizeExtractOnCrossjoin.nodeCondition(node, traceMsg);
        this.traceNodeCondition(result, traceMsg.toString(), trace);
        return result;
    }

    public static boolean nodeCondition(IXQEQueryNode node, StringBuilder traceMsg) {
        if (!node.validateChildCategories()) {
            if (traceMsg != null) {
                traceMsg.append("The child nodes of the target MDXExtract node are invalid.");
            }
            return false;
        }
        if (node.getNumberChildren() > 2) {
            if (traceMsg != null) {
                traceMsg.append("The MDXExtract function is applied to more than a single hierarchy.");
            }
            return false;
        }
        if (node.getChild(0).getType() != 1030) {
            if (traceMsg != null) {
                traceMsg.append("The first operand of the target MDXExtract node is not an MDXCrossjoin node.");
            }
            return false;
        }
        MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)node.getChild(0);
        if (!mdxCrossjoin.validateChildCategories()) {
            if (traceMsg != null) {
                traceMsg.append("The child nodes of the MDXCrossjoin node are invalid.");
            }
            return false;
        }
        MDXHierInfo setHierInfo = mdxCrossjoin.getHierarchyInfo();
        if (setHierInfo.getNumProjectedHierarchies() == 0) {
            if (traceMsg != null) {
                traceMsg.append("The first operand of the MDXExtract function does not project at least one hierarchy.");
            }
            return false;
        }
        AbstractMDXHierarchy extractHierarachy = (AbstractMDXHierarchy)node.getChild(1);
        MDXHierInfo hierInfo = extractHierarachy.getHierarchyInfo();
        if (hierInfo.getNumProjectedHierarchies() != 1 || !setHierInfo.projectsHierarchy(hierInfo.getProjectedHierarchy(0))) {
            if (traceMsg != null) {
                traceMsg.append("Either the hierarchy of the second MDXExtract function cannot be determined, or the specified hierarchy is not projected by the first set operand.");
            }
            return false;
        }
        if (traceMsg != null) {
            traceMsg.append("The transformation is applicable to the target node.");
        }
        return true;
    }
}

