/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.BaseHierarchy;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class RemoveEmptySetWithinMDXSet
extends Transformation {
    public RemoveEmptySetWithinMDXSet(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Remove empty set within MDXSet";
        this.mTypes = new int[]{1039};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXSet mdxSet = (MDXSet)node;
        MDXHierInfo hierInfo = mdxSet.getHierarchyInfo();
        boolean foundEmptySet = true;
        block0: while (foundEmptySet) {
            foundEmptySet = false;
            for (int childIdx = 0; childIdx < node.getNumberChildren(); ++childIdx) {
                IXQEQueryNode childNode = node.getChild(childIdx);
                if (!childNode.isOfCategory(1021) || !((AbstractMDXSet)childNode).isEmpty()) continue;
                node.detachChild(childIdx);
                foundEmptySet = true;
                continue block0;
            }
        }
        if (node.getNumberChildren() == 0) {
            XQENodeFactory nodeFactory = environment.getNodeFactory();
            AbstractMDXSet emptySet = (AbstractMDXSet)nodeFactory.createNode(1145);
            BaseHierarchy mdxBaseHierarchy = (BaseHierarchy)nodeFactory.createNode(1073);
            mdxBaseHierarchy.bind(hierInfo.getProjectedHierarchy(0));
            emptySet.addChild(mdxBaseHierarchy);
            node.getParent().exchangeChildNode(node, emptySet);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the target MDXSet node are invalid.", trace);
            return false;
        }
        if (node.getNumberChildren() < 2) {
            this.traceNodeCondition(false, "The target node has less than 2 children.", trace);
            return false;
        }
        if (node.getDescendantsOfType(1004, false).length > 0) {
            this.traceNodeCondition(false, "The target node has a descendant which is a set alias definition.", trace);
            return false;
        }
        boolean foundEmptySet = false;
        boolean foundNonEmptySet = false;
        for (int childIdx = 0; childIdx < node.getNumberChildren(); ++childIdx) {
            IXQEQueryNode childNode = node.getChild(childIdx);
            if (childNode.isOfCategory(1021) && childNode.getType() != 1027 && ((AbstractMDXSet)childNode).isEmpty()) {
                foundEmptySet = true;
                continue;
            }
            foundNonEmptySet = true;
        }
        if (foundEmptySet && foundNonEmptySet) {
            this.traceNodeCondition(true, "The is a child of the target MDXSet node which is an empty set and a child which is not an empty set.", trace);
            return true;
        }
        this.traceNodeCondition(true, "None of the child nodes of the target MDXSet node is an empty set.", trace);
        return false;
    }
}

