/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveRedundantAncestor
extends Transformation {
    public RemoveRedundantAncestor() {
        this.mPassNumbers = new int[]{41};
        this.mName = "Remove redundant ancestor function";
        this.mTypes = new int[]{1043, 1044};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.detachChild(1);
        if (node.getType() == 1044) {
            XQENodeFactory factory = environment.getNodeFactory();
            IXQEQueryNode mdxSet = factory.createNode(1039);
            node.exchange(mdxSet, true);
        } else {
            node.extract();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXLevelInfo levelInfo;
        IHierarchy hierarchy;
        XQETrace trace = environment.getTrace();
        AbstractMDXNode ancestor = (AbstractMDXNode)node;
        MDXLevelInfo contextLevelInfo = ancestor.getContextLevelInfo();
        if (contextLevelInfo.getNumProjectedLevels(hierarchy = (levelInfo = ancestor.getLevelInfo()).getHierarchyInfo().getProjectedHierarchy(0)) != 1 || levelInfo.getNumProjectedLevels(hierarchy) != 1) {
            this.traceNodeCondition(false, "The context level information contains more than one level", trace);
            return false;
        }
        if (contextLevelInfo.getProjectedLevel(hierarchy, 0).equals(levelInfo.getProjectedLevel(hierarchy, 0)) && ancestor.getChild(0).isOfCategory(1076)) {
            this.traceNodeCondition(true, "The ancestor function can be removed.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The ancestor function cannot be removed.", trace);
        return false;
    }
}

