/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXHierarchize;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class RemoveUnnecessaryHierarchize
extends Transformation {
    public RemoveUnnecessaryHierarchize(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Remove Unnecessary MDXHierchize nodes.";
        this.mTypes = new int[]{1037};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child node of the MDXHierarchize node is invalid.", trace);
            return false;
        }
        if (((MDXHierarchize)node).getPost()) {
            this.traceNodeCondition(false, "The MDXHierarchize reverses the order of the set.", trace);
            return false;
        }
        if (!((AbstractMDXSet)node.getChild(0)).isHierarchized()) {
            this.traceNodeCondition(false, "The MDXHierarchize operand could project un-hierarchized tuples.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The MDXHierarchize operand projects hierarchized tuples.", trace);
        return true;
    }
}

