/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class ReplaceHeadTailZeroWithEmptySet
extends Transformation {
    public ReplaceHeadTailZeroWithEmptySet(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Replace Head/Tail With Length Zero With Empty Set";
        this.mTypes = new int[]{1042};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        AbstractMDXSet emptySet = MDXBuilder.buildEmptySet(nodeFactory, (AbstractMDXSet)node.getChild(0));
        node.getParent().exchangeChildNode(node, emptySet, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the target node are invalid.", trace);
            return false;
        }
        if (node.getDescendantsOfType(1004, false).length > 0) {
            this.traceNodeCondition(false, "The target node has a descendant which is a set alias definition.", trace);
            return false;
        }
        if (node.getNumberChildren() == 2 && node.getChild(1).getType() == 1064) {
            Object lengthValue = ((MDXNumericConstant)node.getChild(1)).getConstantValue();
            Integer zero = XQEIntegerPool.getInteger(0);
            if (lengthValue instanceof Integer && zero.compareTo((Integer)lengthValue) == 0) {
                this.traceNodeCondition(true, "The target node has a length argument of zero.", trace);
                return true;
            }
        }
        this.traceNodeCondition(false, "The target node does not return an empty set.", trace);
        return false;
    }
}

