/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class ReplaceNoMemberMeasureDefaultMemberWithNullMeasure
extends Transformation {
    public ReplaceNoMemberMeasureDefaultMemberWithNullMeasure(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Replace no member measure default member with a null calculated measure.";
        this.mTypes = new int[]{1077};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        int solveOrder = SolveOrderUtil.findSolveOrderOfAncestorCalc(node);
        if (solveOrder == SolveOrderUtil.getUndefinedMDXSolveOrder()) {
            solveOrder = SolveOrderUtil.getCubeCalcSolveOrder();
        }
        MDXCalculatedMemberReference mdxNullMeasure = MDXBuilder.buildMDXFillerMeasureExpr(nodeFactory, ((MDXDefaultMember)node).getHierarchyInfo().getProjectedHierarchy(0), mdxQuery, solveOrder);
        node.getParent().exchangeChildNode(node, mdxNullMeasure, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the target MDXDefaultMember node are invalid.", trace);
            return false;
        }
        MDXDefaultMember mdxDefMem = (MDXDefaultMember)node;
        if (!mdxDefMem.getPropertyIsNoMember()) {
            this.traceQueryCondition(true, "The node is not NoMember", trace);
            return false;
        }
        if (!mdxDefMem.getHierarchyInfo().getProjectedHierarchy(0).getDimension().isMeasuresDimension()) {
            this.traceQueryCondition(true, "The node is not a measure", trace);
            return false;
        }
        MDXEdge edge = (MDXEdge)node.getAncestorOfType(1006);
        if (edge == null || !edge.isProjectedDescendant(mdxDefMem)) {
            this.traceNodeCondition(false, "The node is not projected on the edge.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (!mdxQuery.isV5QueryHintPropagated()) {
            this.traceNodeCondition(false, "MDXEdge.PROP_BOOLEAN_MDX_NON_EMPTY is not set yet.", trace);
            return false;
        }
        RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
        if (rsapiDataset.isListReport()) {
            this.traceNodeCondition(false, "The transformation is not applicable foe LIST cases for now.", trace);
            return false;
        }
        if (mdxDefMem.getParent() != null && mdxDefMem.getParent().isOfCategory(1069) && node.getParent().getNumberChildrenOfType(1013) > 0) {
            this.traceNodeCondition(false, "The transformation is not applicable for TUPLE children for now.", trace);
            return false;
        }
        this.traceQueryCondition(true, "Node is a NoMember default measure.", trace);
        return true;
    }
}

