/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class ReplaceSetOperatorOnEmptySetWithEmptySet
extends Transformation {
    public ReplaceSetOperatorOnEmptySetWithEmptySet(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Replace Set Operator On Empty Set With Empty Set";
        this.mTypes = new int[]{1048, 1030, 1052, 1033, 1032, 1128, 1106, 1053, 1057, 1042, 1037, 1038, 1074, 1040, 1058, 1075, 1147, 1039, 1051, 1090, 1041, 1146};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        AbstractMDXSet emptySet = MDXBuilder.buildEmptySet(nodeFactory, (AbstractMDXSet)node);
        node.getParent().exchangeChildNode(node, emptySet, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the target node are invalid.", trace);
            return false;
        }
        if (node.getDescendantsOfType(1004, false).length > 0) {
            this.traceNodeCondition(false, "The target node has a descendant which is a set alias definition.", trace);
            return false;
        }
        MDXCalculatedMemberDefinition calc = (MDXCalculatedMemberDefinition)node.getAncestorOfType(1005);
        if (calc != null && calc.isAdjustedForIncompatibleNestingContext()) {
            this.traceNodeCondition(false, "The target node is in the definition of a calculated member already ajusted for context", trace);
            return false;
        }
        if (calc != null && calc.isSlicerCalcIntersectingWithSeveralProjCalc()) {
            this.traceNodeCondition(false, "The target node is in the definition of a calculated member used as slicer on the measure edge", trace);
            return false;
        }
        switch (node.getType()) {
            case 1030: 
            case 1057: {
                if (!node.getChild(0).isOfTypes(this.mTypes) || !node.getChild(1).isOfTypes(this.mTypes)) break;
                this.traceNodeCondition(false, "Both children are set operators that can be repalced with an empty set first.", trace);
                return false;
            }
            case 1032: 
            case 1106: {
                if (!node.getChild(0).isOfTypes(this.mTypes)) break;
                this.traceNodeCondition(false, "Check to see if the first child can be repalced with an empty set first.", trace);
                return false;
            }
            case 1039: {
                for (IXQEQueryNode child : node.getChildren()) {
                    if (child.isOfCategory(1021) && !child.isOfTypes(this.mTypes)) continue;
                    this.traceNodeCondition(false, "One child is not an AbstractMDXSet node or this transformation should be called on a child first.", trace);
                    return false;
                }
                break;
            }
            case 1033: 
            case 1037: 
            case 1041: 
            case 1053: 
            case 1058: 
            case 1090: 
            case 1128: {
                for (IXQEQueryNode child : node.getChildren()) {
                    if (!child.isOfCategory(1021) || !child.isOfTypes(this.mTypes)) continue;
                    this.traceNodeCondition(false, "One of the child AbstractMDXSet nodes should be replaced with an empty set first.", trace);
                    return false;
                }
                break;
            }
        }
        if (((AbstractMDXSet)node).isEmpty()) {
            this.traceNodeCondition(true, "The target returns an empty set.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The target node does not return an empty set.", trace);
        return false;
    }
}

