/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.BaseHierarchy;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.CogMDXSummaryFilter;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXFilter;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;

public final class ReplaceTNodeTrueFalse
extends Transformation {
    public static final String UNEXPECTED_TYPE = "parentType?";

    public ReplaceTNodeTrueFalse() {
        this.mName = "Replace TNodeTrueFalse";
        this.mPassNumbers = new int[]{0, 41};
        this.mTypes = new int[]{1165};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        if (node.getBooleanPropertyValue("equalsTrue").booleanValue()) {
            this.replaceTrueNode(node, factory, environment);
        } else {
            this.replaceFalseNode(node, factory, environment);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        this.traceNodeCondition(true, "The boolean node will be replaced.", trace);
        return true;
    }

    private void replaceTrueNode(IXQEQueryNode tNodeTrueFalse, IXQENodeFactory factory, PlanningEnvironment environment) {
        IXQEQueryNode parent = tNodeTrueFalse.getParent();
        int parentType = parent.getType();
        String expression = null;
        switch (parentType) {
            case 1111: {
                tNodeTrueFalse.setPropertyValue("equalsTrue", true);
                parent.getParent().exchangeChildNode(parent, tNodeTrueFalse.detach(), false);
                break;
            }
            case 1109: {
                tNodeTrueFalse.setPropertyValue("equalsTrue", false);
                parent.getParent().exchangeChildNode(parent, tNodeTrueFalse.detach(), false);
                break;
            }
            case 1110: {
                this.replaceParentWithOtherChild(tNodeTrueFalse.getParent(), tNodeTrueFalse);
                break;
            }
            case 1010: {
                tNodeTrueFalse.detach();
                parent.detach();
                expression = ((CogMDXDetailFilter)parent).getOriginalExpression();
                break;
            }
            case 1011: {
                tNodeTrueFalse.detach();
                parent.detach();
                expression = ((CogMDXSummaryFilter)parent).getOriginalExpression();
                break;
            }
            case 1085: 
            case 1086: 
            case 1168: {
                IXQEQueryNode op1 = parent.getChild(1).detach();
                parent.getParent().exchangeChildNode(parent, op1);
                break;
            }
            case 1053: {
                parent.getParent().exchangeChildNode(parent, parent.getChild(0).detach());
                break;
            }
            default: {
                parent.throwInternalError(UNEXPECTED_TYPE);
            }
        }
        ReplaceTNodeTrueFalse.constantFilteringExpressionWarning(environment, expression, true);
    }

    private void replaceFalseNode(IXQEQueryNode tNodeTrueFalse, IXQENodeFactory factory, PlanningEnvironment environment) {
        IXQEQueryNode parent = tNodeTrueFalse.getParent();
        int parentType = parent.getType();
        String expression = null;
        switch (parentType) {
            case 1111: {
                this.replaceParentWithOtherChild(tNodeTrueFalse.getParent(), tNodeTrueFalse);
                break;
            }
            case 1109: {
                tNodeTrueFalse.setPropertyValue("equalsTrue", true);
                parent.getParent().exchangeChildNode(parent, tNodeTrueFalse.detach(), false);
                break;
            }
            case 1110: {
                tNodeTrueFalse.setPropertyValue("equalsTrue", false);
                parent.getParent().exchangeChildNode(parent, tNodeTrueFalse.detach(), false);
                break;
            }
            case 1010: {
                MDXQuery query = (MDXQuery)tNodeTrueFalse.getAncestorOfCategory(1002);
                ReplaceTNodeTrueFalse.clearQuery(factory, query);
                expression = ((CogMDXDetailFilter)parent).getOriginalExpression();
                break;
            }
            case 1011: {
                expression = ((CogMDXSummaryFilter)parent).getOriginalExpression();
                break;
            }
            case 1085: 
            case 1086: 
            case 1168: {
                IXQEQueryNode op2 = parent.getChild(2).detach();
                parent.getParent().exchangeChildNode(parent, op2);
                break;
            }
            case 1053: {
                MDXFilter mdxFilter = (MDXFilter)parent;
                AbstractMDXSet emptySet = MDXBuilder.buildEmptySet(factory, mdxFilter);
                parent.getParent().exchangeChildNode(parent, emptySet);
                break;
            }
            default: {
                parent.throwInternalError(UNEXPECTED_TYPE);
            }
        }
        ReplaceTNodeTrueFalse.constantFilteringExpressionWarning(environment, expression, false);
    }

    public static void constantFilteringExpressionWarning(PlanningEnvironment environment, String expression, boolean value) {
        String booleanValue = null;
        booleanValue = value ? "true" : "false";
        if (expression != null) {
            int aSeverity = 1;
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_ConstantFilteringExpression, expression, booleanValue));
        }
    }

    public static void clearQuery(IXQENodeFactory factory, MDXQuery query) {
        MDXEdge[] edges = query.getEdges();
        MDXFromCube from = query.getMDXFrom();
        query.detachChildren();
        if (edges.length != 0) {
            for (MDXEdge edge : edges) {
                IHierarchy hierarchy = edge.getHierarchyInfo().getProjectedHierarchy(0);
                edge.detachChildren();
                AbstractMDXSet set = (AbstractMDXSet)factory.createNode(1145);
                BaseHierarchy baseHierarchy = (BaseHierarchy)factory.createNode(1073);
                baseHierarchy.bind(hierarchy);
                set.addChild(baseHierarchy);
                edge.addChild(set);
                query.addChild(edge);
            }
        }
        query.addChild(from);
    }

    private void replaceParentWithOtherChild(IXQEQueryNode parent, IXQEQueryNode child) {
        if (parent.getNumberChildren() != 2) {
            parent.throwInternalError("getNumberChildren() != 2");
        }
        IXQEQueryNode otherChild = parent.getPositionOfChild(child) == 1 ? parent.getChild(0) : parent.getChild(1);
        parent.exchange(otherChild, false);
    }
}

