/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.generate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXGenerate;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class OptimizeGenerateCurrentMember
extends Transformation {
    public OptimizeGenerateCurrentMember(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Optimize Generate Current Member.";
        this.mTypes = new int[]{1057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode set = node.detachChild(0);
        node.getParent().exchangeChildNode(node, set);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXHierInfo currMemHierInfo;
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the MDXGenerate node are invalid.", trace);
            return false;
        }
        if (node.getChild(1).getType() != 1039) {
            this.traceNodeCondition(false, "The second operand of the target MDXGenerate node is not an MDXSet node.", trace);
            return false;
        }
        if (node.getChild(1).getNumberChildren() != 1 || node.getChild(1).getChild(0).getType() != 1076) {
            this.traceNodeCondition(false, "The second operand of the target MDXGenerate node is not an MDXSet node with a single MDXCurrentMember child node.", trace);
            return false;
        }
        MDXHierInfo setHierInfo = ((AbstractMDXSet)node.getChild(0)).getHierarchyInfo();
        if (!setHierInfo.compareProjectedHierarchies(currMemHierInfo = ((AbstractMDXSet)node.getChild(1)).getHierarchyInfo())) {
            this.traceNodeCondition(false, "The first and second operands of the target MDXGenerate node do not project the same hierarchy.", trace);
            return false;
        }
        if (!((MDXGenerate)node).getAll() && ((AbstractMDXSet)node.getChild(0)).projectsDuplicates()) {
            this.traceNodeCondition(false, "The target MDXGenerate node does not project duplicates and the first set operand does project duplicates.", trace);
            return false;
        }
        this.traceNodeCondition(false, "The transformation is applicable to the target node.", trace);
        return true;
    }
}

