/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.generate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXHierarchy;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class OptimizeGenerateOnListOfMembersWithIntersect
extends Transformation {
    public OptimizeGenerateOnListOfMembersWithIntersect(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Replace GENERATE( { members }, INTERSECT ( CURRENTMEMBER, ... ) ) by INTERSECT( { members } , ... ).";
        this.mTypes = new int[]{1057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode setOfBaseMembers = node.getChild(0);
        IXQEQueryNode intersect = node.getChild(1);
        intersect.exchangeChildNode(intersect.getChild(0), setOfBaseMembers, false);
        node.getParent().exchangeChildNode(node, intersect, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getNumberChildren() == 2) {
            IXQEQueryNode firstChild = node.getChild(0);
            IXQEQueryNode secondChild = node.getChild(1);
            if (firstChild.getType() == 1039) {
                IHierarchy hierarchy;
                IHierarchy memberHierarchy;
                IXQEQueryNode currentMemberHierarchy;
                IXQEQueryNode currentMember;
                IXQEQueryNode currentMemberSet;
                MDXHierInfo mdxSetHierInfo = ((MDXSet)firstChild).getHierarchyInfo();
                if (((MDXSet)firstChild).isListOfNonDuplicatedBaseMembers() && mdxSetHierInfo.getNumProjectedHierarchies() == 1 && secondChild.getType() == 1038 && secondChild.getNumberChildren() == 2 && (currentMemberSet = secondChild.getChild(0)).getType() == 1039 && (currentMember = currentMemberSet.getChild(0)).getType() == 1076 && currentMember.getNumberChildren() == 1 && (currentMemberHierarchy = currentMember.getChild(0)).isOfCategory(1072) && (memberHierarchy = mdxSetHierInfo.getProjectedHierarchy(0)).equals(hierarchy = ((AbstractMDXHierarchy)currentMemberHierarchy).getHierarchy())) {
                    status = true;
                    this.traceNodeCondition(status, "Generate the Intersect of the current member for a list non-duplicated members.", trace);
                }
            }
        }
        if (!status) {
            this.traceNodeCondition(status, "The expression is not a valid one to optimize.", trace);
        }
        return status;
    }
}

