/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.intersect;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXIntersect;
import com.cognos.xqe.ast.olap.MDXMembers;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class OptimizeIntersectOnMembers
extends Transformation {
    public OptimizeIntersectOnMembers() {
        this.mName = "Optimize Intersect On Members.";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{1038};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode membersChild = node.getChild(1);
        IXQEQueryNode otherChild = node.getChild(0);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        if (node.getChild(0).getType() == 1040) {
            boolean useHierarchize;
            membersChild = node.getChild(0);
            otherChild = node.getChild(1);
            boolean useDistinct = ((AbstractMDXSet)otherChild).projectsDuplicates();
            boolean bl = useHierarchize = !((AbstractMDXSet)otherChild).isHierarchized();
            if (useDistinct) {
                otherChild.insertParent(nodeFactory.createNode(1033));
            }
            if (useHierarchize) {
                otherChild.insertParent(nodeFactory.createNode(1037));
            }
        } else {
            boolean useDistinct;
            boolean bl = useDistinct = ((AbstractMDXSet)otherChild).projectsDuplicates() && !((MDXIntersect)node).getAll();
            if (useDistinct) {
                otherChild.insertParent(nodeFactory.createNode(1033));
            }
        }
        node.detachChild(membersChild);
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the MDXIntersect node are invalid.", trace);
            return false;
        }
        IXQEQueryNode membersChild = node.getChild(0);
        IXQEQueryNode otherChild = node.getChild(1);
        if (node.getChild(1).getType() == 1040) {
            membersChild = node.getChild(1);
            otherChild = node.getChild(0);
        }
        if (membersChild.getType() != 1040) {
            this.traceNodeCondition(false, "No operand of the MDXIntersect node is a MDXMembers node.", trace);
            return false;
        }
        MDXMembers mdxMembers = (MDXMembers)membersChild;
        if (mdxMembers.getChild(0).isOfCategory(1072)) {
            MDXHierInfo set2HierInfo;
            MDXHierInfo set1HierInfo = mdxMembers.getHierarchyInfo();
            if (!set1HierInfo.compareProjectedHierarchies(set2HierInfo = ((AbstractMDXSet)otherChild).getHierarchyInfo())) {
                this.traceNodeCondition(false, "The operands of the MDXIntersect node do not project the same single hierarchy.", trace);
                return false;
            }
        } else {
            MDXLevelInfo set2LevelInfo;
            MDXLevelInfo set1LevelInfo = mdxMembers.getLevelInfo();
            if (!set1LevelInfo.compareProjectedLevels(set2LevelInfo = ((AbstractMDXSet)otherChild).getLevelInfo())) {
                this.traceNodeCondition(false, "The operands of the MDXIntersect node do not project the same level.", trace);
                return false;
            }
        }
        this.traceNodeCondition(true, "One operand of the MDXIntersect node is a MDXMembers function, and both operands project the same hierarchy or single level.", trace);
        return true;
    }
}

