/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.intersect;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.BaseLevel;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class OptimizeIntersectOnSingleMember
extends Transformation {
    public OptimizeIntersectOnSingleMember(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Replace MDX INTERSECT of a level with a single member.";
        this.mTypes = new int[]{1038};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode levelChild = node.getChild(0);
        IXQEQueryNode memberChild = node.getChild(1);
        if (levelChild.getType() == 1014) {
            levelChild = ((MDXNamedSetReference)levelChild).getDefinition().getChild(0);
        }
        if (memberChild.getType() == 1014) {
            memberChild = ((MDXNamedSetReference)memberChild).getDefinition().getChild(0);
        }
        if (levelChild.getType() == 1039) {
            IXQEQueryNode tempChild = levelChild;
            levelChild = memberChild;
            memberChild = tempChild;
        }
        IXQEQueryNode baseLevel = levelChild.getChild(0);
        IXQEQueryNode baseMember = memberChild.getChild(0);
        node.detachChild(levelChild);
        node.extract();
        MDXLevelInfo baseLevelInfo = ((BaseLevel)baseLevel).getLevelInfo();
        MDXLevelInfo baseMemberExprInfo = ((BaseMember)baseMember).getLevelInfo();
        if (!baseLevelInfo.compareProjectedLevels(baseMemberExprInfo)) {
            XQENodeFactory nodeFactory = environment.getNodeFactory();
            AbstractMDXSet emptySet = MDXBuilder.buildEmptySet(nodeFactory, (AbstractMDXSet)memberChild);
            memberChild.getParent().exchangeChildNode(memberChild, emptySet, false);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        IXQEQueryNode[] children = node.getChildren();
        if (children.length == 2) {
            IXQEQueryNode firstChild = children[0];
            IXQEQueryNode secondChild = children[1];
            if (firstChild.getType() == 1014) {
                firstChild = ((MDXNamedSetReference)firstChild).getDefinition().getChildren()[0];
            }
            if (secondChild.getType() == 1014) {
                secondChild = ((MDXNamedSetReference)secondChild).getDefinition().getChildren()[0];
            }
            if (firstChild.getType() == 1040 && secondChild.getType() == 1039) {
                IXQEQueryNode baseMember;
                IXQEQueryNode baseLevel = firstChild.getChildren()[0];
                if (secondChild.getNumberChildren() == 1 && baseLevel.getType() == 1065 && (baseMember = secondChild.getChildren()[0]).getType() == 1067) {
                    status = true;
                    this.traceNodeCondition(status, "INTERSECT members from a level with a base member on this level.", trace);
                }
            } else if (secondChild.getType() == 1040 && firstChild.getType() == 1039) {
                IXQEQueryNode baseMember;
                IXQEQueryNode baseLevel = secondChild.getChildren()[0];
                if (firstChild.getNumberChildren() == 1 && baseLevel.getType() == 1065 && (baseMember = firstChild.getChildren()[0]).getType() == 1067) {
                    status = true;
                    this.traceNodeCondition(status, "INTERSECT a base member from a level with members from that level.", trace);
                }
            }
        }
        if (!status) {
            this.traceNodeCondition(status, "Do not INTERSECT members from a level with a base member on this level.", trace);
        }
        return status;
    }
}

