/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.set;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveSetFromDimensionLine
extends Transformation {
    public RemoveSetFromDimensionLine() {
        this.mName = "RemoveSetFromDimensionLine removes an MDXSet from the dimension line.";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{1039};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        if (node.getChild(0).isOfCategory(1068)) {
            node.extract();
        } else {
            IXQEQueryNode tuple = factory.createNode(1069);
            node.exchange(tuple, true);
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceQueryCondition(false, "The target MDXSet node has invalid child nodes.", trace);
            return false;
        }
        if (node.getParent().getType() != 1008) {
            this.traceQueryCondition(false, "The target MDXSet node does not is not on the dimension line.", trace);
            return false;
        }
        if (node.getNumberChildren() != 1) {
            this.traceQueryCondition(false, "The target MDXSet node doesn't have only one child.", trace);
            return false;
        }
        if (node.getChild(0).isOfCategory(1021)) {
            this.traceQueryCondition(false, "The target MDXSet node has a child which is a set.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The target MDXSet node is on the dimension line and has only one child.", trace);
        return true;
    }
}

