/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.projection;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXLevel;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSetOperator;
import com.cognos.xqe.ast.olap.MDXDescendants;
import com.cognos.xqe.ast.olap.MDXMembers;
import com.cognos.xqe.ast.olap.MDXParent;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.projection.MakeNestedGroupedMDXMemberOnHierarchyContextDependent;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;

public final class MakeNestedGroupedMDXMembersOnLevelContextDependent
extends Transformation {
    private static final String NO_CONTEXTINFO_FAILURE1 = "";

    public MakeNestedGroupedMDXMembersOnLevelContextDependent() {
        this.mName = "Make Nested Grouped MDXMembers On Level Expressions Context Dependent.";
        this.mPassNumbers = new int[]{20};
        this.mTypes = new int[]{1040};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXLevelInfo mdxMembersLevelInfo = ((MDXMembers)node).getLevelInfo();
        IHierarchy hierarchy = mdxMembersLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
        int setLevelIndex = mdxMembersLevelInfo.getHighestProjectedLevel(hierarchy).getIndex();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        AbstractMDXNode nodeToFindContextFrom = MakeNestedGroupedMDXMemberOnHierarchyContextDependent.getNodeToCheckContextFrom((MDXMembers)node, mdxQuery);
        MDXLevelInfo contextLevelInfo = nodeToFindContextFrom.getContextLevelInfo();
        int contextHighestLevelIndex = contextLevelInfo.getHighestProjectedLevel(hierarchy).getIndex();
        int contextLowestLevelIndex = contextLevelInfo.getLowestProjectedLevel(hierarchy).getIndex();
        this.createContextDependentSet(factory, node, setLevelIndex, hierarchy, contextHighestLevelIndex, contextLowestLevelIndex, true);
    }

    protected IXQEQueryNode createContextDependentSet(IXQENodeFactory factory, IXQEQueryNode node, int setLevelIndex, IHierarchy hierarchy, int contextHighestLevelIndex, int contextLowestLevelIndex, boolean bReplaceNode) {
        AbstractMDXSetOperator newNode = null;
        if (contextHighestLevelIndex == contextLowestLevelIndex && contextHighestLevelIndex == setLevelIndex) {
            newNode = MDXBuilder.buildMDXSetExpr(factory, MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy));
        } else if (contextLowestLevelIndex <= setLevelIndex) {
            newNode = MDXBuilder.buildMDXDescendantsExpr(factory, (AbstractMDXMember)MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy), (AbstractMDXLevel)node.detachChild(0), 0);
        } else if (contextHighestLevelIndex >= setLevelIndex) {
            newNode = MDXBuilder.buildMDXSetExpr(factory, MDXBuilder.buildMDXAncestorExpr(factory, (AbstractMDXMember)MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy), (AbstractMDXLevel)node.detachChild(0)));
        } else {
            AbstractMDXLevel level = (AbstractMDXLevel)node.detachChild(0);
            MDXDescendants mdxDescendants = MDXBuilder.buildMDXDescendantsExpr(factory, (AbstractMDXMember)MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy), level, 0);
            mdxDescendants.setPropertyValue("RemoveInvalidTuplesFromNestedSetExpression", "applied");
            MDXParent mdxParent = MDXBuilder.buildMDXParentExpr(factory, MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy));
            MDXSet mdxAncestorSet = MDXBuilder.buildMDXSetExpr(factory, MDXBuilder.buildMDXAncestorExpr(factory, (AbstractMDXMember)mdxParent, (AbstractMDXLevel)factory.deepCopyNode(level)));
            mdxAncestorSet.setPropertyValue("RemoveInvalidTuplesFromNestedSetExpression", "applied");
            AbstractMDXNode[] children = new AbstractMDXNode[]{mdxAncestorSet, mdxDescendants};
            newNode = MDXBuilder.buildMDXSetExpr(factory, children);
        }
        newNode.setPropertyValue("RemoveInvalidTuplesFromNestedSetExpression", "applied");
        if (bReplaceNode) {
            node.getParent().exchangeChildNode(node, newNode, false);
        }
        return newNode;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (((MDXMembers)node).isFlaggedContextIndependent()) {
            this.traceNodeCondition(false, "The MDXMembers node is flagged as context independent.", trace);
            return false;
        }
        if (!((MDXMembers)node).validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the MDXMembers node are invalid.", trace);
            return false;
        }
        if (!((MDXMembers)node).getChild(0).isOfCategory(1023)) {
            this.traceNodeCondition(false, "The MDXMembers expression is not applied to a level.", trace);
            return false;
        }
        IXQEQueryNode cogMDXNest = node.getAncestorOfType(1026);
        if (cogMDXNest != null) {
            this.traceNodeCondition(false, "The MDXMembers expression is not part of a grouped expression.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceQueryCondition(false, "The target MDXMembers node is not a descendant of an MDXQuery node.", trace);
            return false;
        }
        AbstractMDXNode nodeToCheck = MakeNestedGroupedMDXMemberOnHierarchyContextDependent.getNodeToCheckContextFrom((MDXMembers)node, mdxQuery);
        if (nodeToCheck == null) {
            return false;
        }
        IHierarchy hierarchy = MakeNestedGroupedMDXMemberOnHierarchyContextDependent.getHierarchyForReportSummary(nodeToCheck, (AbstractMDXNode)node);
        MDXHierInfo contextHierInfo = nodeToCheck.getContextHierarchyInfo();
        if (!contextHierInfo.projectsHierarchy(hierarchy)) {
            this.traceNodeCondition(false, " that includes the hierarchy projected by the MDXMembers expression.", trace);
            return false;
        }
        MDXLevelInfo contextLevelInfo = nodeToCheck.getContextLevelInfo();
        contextLevelInfo.removeNoMemberLevels(hierarchy);
        if (contextLevelInfo.getHighestProjectedLevel(hierarchy) == null) {
            this.traceNodeCondition(false, ".", trace);
            return false;
        }
        this.traceNodeCondition(true, "The target MDXMembers expression is a descendant of a CogMDXGroup node for which the context information includes the hierarchy projected by the MDXMembers expression.", trace);
        return true;
    }
}

