/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXNamedSetDefinition;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import java.util.HashMap;

public final class TagCalculatedMembersForPrimingQuery
extends Transformation {
    private static final int NOT_PRIMABLE = 0;
    private static final int PRIME_WRONG_MEMBERS = 1;
    private static final int PRIME_WRONG_VALUES = 2;
    private static final int PRIMABLE = 3;
    private static final String PRIMING_TAG = "primingTag";
    private static final String NEW_LINE = "\n";
    private static final String NOT_PRIMABLE_STRING = "NOT_PRIMABLE";
    private static final String PRIME_WRONG_MEMBERS_STRING = "PRIME_WRONG_MEMBERS";
    private static final String PRIME_WRONG_VALUES_STRING = "PRIME_WRONG_VALUES";
    private static final String PRIMABLE_STRING = "PRIMABLE";
    private static XQELogger queryPrimeLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "PrimingQuery", LogLevel.ERROR);

    public TagCalculatedMembersForPrimingQuery() {
        this.mName = "Tag each calculated member with a priming mode.";
        this.mPassNumbers = new int[]{53};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] namedSets;
        MDXQuery mdxQuery = (MDXQuery)node;
        for (IXQEQueryNode namedSet : namedSets = mdxQuery.getDescendantsOfType(1003, false)) {
            this.tagNamedSet(mdxQuery, namedSet);
        }
        IXQEQueryNode[] calcDefs = mdxQuery.getDescendantsOfType(1005, false);
        HashMap<String, Integer> calcToMembersMap = new HashMap<String, Integer>();
        for (IXQEQueryNode calcDef : calcDefs) {
            int primingLevel = this.getPrimingMode(calcDef.getChild(0));
            if (primingLevel > 0) {
                calcToMembersMap.put(((MDXCalculatedMemberDefinition)calcDef).getUniqueName(), primingLevel);
            }
            this.logPrimingMode(mdxQuery, calcDef, primingLevel);
        }
        mdxQuery.setCalcToPrimingModeMap(calcToMembersMap);
        environment.setTreeHasBeenModified();
    }

    private int tagNamedSet(MDXQuery mdxQuery, IXQEQueryNode namedSet) {
        IXQEQueryNode[] childNamedSets;
        if (namedSet.getPropertyValue(PRIMING_TAG) != null) {
            return (Integer)namedSet.getPropertyValue(PRIMING_TAG);
        }
        IXQEQueryNode[] childCalcs = namedSet.getDescendantsOfType(1013, false);
        int namedSetPrimingType = 0;
        if (childCalcs.length > 0) {
            namedSet.setPropertyValue(PRIMING_TAG, namedSetPrimingType);
            return namedSetPrimingType;
        }
        for (IXQEQueryNode childNamedSet : childNamedSets = namedSet.getDescendantsOfType(1014, false)) {
            this.tagNamedSet(mdxQuery, ((MDXNamedSetReference)childNamedSet).getDefinition());
        }
        if (this.getPrimingMode(namedSet) == 3) {
            namedSetPrimingType = 3;
        }
        namedSet.setPropertyValue(PRIMING_TAG, namedSetPrimingType);
        return namedSetPrimingType;
    }

    private int getPrimingMode(IXQEQueryNode node) {
        if (node.getType() == 1059) {
            int tuplePrimingType = this.getPrimingMode(node.getChild(0));
            if (tuplePrimingType < 2) {
                return 0;
            }
            return 2;
        }
        if (node.getType() == 1015 || node.getType() == 1004) {
            return 0;
        }
        if (node.getType() == 1085) {
            int conditionPrimingType = this.getPrimingMode(node.getChild(0));
            if (conditionPrimingType == 0) {
                return 0;
            }
            if (conditionPrimingType < 3) {
                return 0;
            }
            int firstChildPrimingType = this.getPrimingMode(node.getChild(1));
            int secondChildPrimingType = this.getPrimingMode(node.getChild(2));
            return Math.min(firstChildPrimingType, secondChildPrimingType);
        }
        if (node.getType() == 1053) {
            int setPrimingType = this.getPrimingMode(node.getChild(0));
            if (setPrimingType < 3) {
                return 0;
            }
            int conditionPrimingType = this.getPrimingMode(node.getChild(1));
            if (conditionPrimingType == 0) {
                return 0;
            }
            if (conditionPrimingType < 3) {
                return 0;
            }
            return 3;
        }
        if (node.getType() == 1041) {
            int valuePrimingType;
            int setPrimingType = this.getPrimingMode(node.getChild(0));
            if (setPrimingType < 2) {
                return 0;
            }
            if (node.getNumberChildren() > 2 && (valuePrimingType = this.getPrimingMode(node.getChild(2))) == 3 && setPrimingType == 3) {
                return 3;
            }
            return 0;
        }
        if (node.getType() == 1014) {
            int namedSetPrimingType = (Integer)((MDXNamedSetReference)node).getDefinition().getPropertyValue(PRIMING_TAG);
            return namedSetPrimingType;
        }
        if (node.getType() == 1087) {
            if (!((MDXCount)node).includeEmpty()) {
                return 0;
            }
            int setPrimingType = this.getPrimingMode(node.getChild(0));
            if (setPrimingType < 2) {
                return 0;
            }
            return 3;
        }
        int minPrimingType = 3;
        for (IXQEQueryNode child : node.getChildren()) {
            int primingType = this.getPrimingMode(child);
            if (primingType == 0) {
                return 0;
            }
            if (primingType >= minPrimingType) continue;
            minPrimingType = primingType;
        }
        return minPrimingType;
    }

    private void logPrimingMode(MDXQuery mdxQuery, IXQEQueryNode node, int mode) {
        if (queryPrimeLogger.isOn(LogLevel.TRACE) && mdxQuery != null) {
            StringBuilder buffer = new StringBuilder(NEW_LINE);
            buffer.append("QueryName: ");
            String queryName = mdxQuery.getRefQueryProperty();
            buffer.append(queryName);
            if (node != null) {
                if (node.getType() == 1003) {
                    buffer.append(", Nameset Name: ");
                    buffer.append(((MDXNamedSetDefinition)node).getUniqueName());
                } else if (node.getType() == 1005) {
                    buffer.append(", Calculation Name: ");
                    buffer.append(((MDXCalculatedMemberDefinition)node).getUniqueName());
                }
                buffer.append(", Prime mode: ");
                switch (mode) {
                    case 1: {
                        buffer.append(PRIME_WRONG_MEMBERS_STRING);
                        break;
                    }
                    case 2: {
                        buffer.append(PRIME_WRONG_VALUES_STRING);
                        break;
                    }
                    case 3: {
                        buffer.append(PRIMABLE_STRING);
                        break;
                    }
                    default: {
                        buffer.append(NOT_PRIMABLE_STRING);
                    }
                }
                buffer.append("\n\nExpression:\n");
                buffer.append(node.dumpToString());
            } else {
                buffer.append(", PRIMING MODE NOT ENABLE");
            }
            queryPrimeLogger.log(LogLevel.TRACE, buffer.toString());
        }
    }

    private boolean primingEnabled(PlanningEnvironment environment, MDXQuery mdxQuery) {
        if (!mdxQuery.getUseLocalQueryProcessing()) {
            return false;
        }
        if (!"execute".equals(((RequestEnvironment)environment.getRequestEnvironment()).getOperationName())) {
            this.traceNodeCondition(false, "Priming calculations is enable for mdx request only", environment.getTrace());
            return false;
        }
        IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
        if (capabilities == null) {
            return false;
        }
        if (capabilities.getBooleanValue("mdx.suppression.beforeEvaluatingExpressions", Boolean.FALSE)) {
            return false;
        }
        if (capabilities.getBooleanValue("v5.planSubQueryForLocalOLAP", Boolean.FALSE)) {
            return false;
        }
        if (capabilities.getBooleanValue("primingEnabled", Boolean.FALSE)) {
            return true;
        }
        boolean bPrimingQueryFromConfigFile = environment.getMultiRequestContext().fetchBooleanConfiguration("queryPlanning.primingQuery[@enabled]", false);
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean bPrimingAdvanceProperty = configuration.getBooleanProperty("qsEnablePrimingQuery", bPrimingQueryFromConfigFile);
        String datasource = mdxQuery.getDataSourceType();
        if (bPrimingAdvanceProperty) {
            return true;
        }
        if (bPrimingQueryFromConfigFile) {
            StringBuffer doPrimingEnable = new StringBuffer("queryPlanning.primingQuery");
            doPrimingEnable.append(".");
            doPrimingEnable.append(datasource);
            doPrimingEnable.append("[@enabled]");
            if (environment.getMultiRequestContext().fetchBooleanConfiguration(doPrimingEnable.toString(), false)) {
                return true;
            }
        }
        this.logPrimingMode(mdxQuery, null, 0);
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        if (mdxQuery.getCalcToPrimingModeMap() != null) {
            this.traceQueryCondition(false, "Priming mode map has already been added.", trace);
            return false;
        }
        if (!this.primingEnabled(environment, mdxQuery)) {
            this.traceQueryCondition(false, "Priming calculations is not enabled.", trace);
            return false;
        }
        this.traceQueryCondition(true, "Priming mode map needs to be created.", trace);
        return true;
    }
}

