/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.essbase;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.essbase.EssbaseTransformation;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;

public class ExpandMUNForLOLAP
extends EssbaseTransformation {
    private static final String MSG_ERROR_PARSING_ESSBASE_UNIQUE_NAME = "Error parsing essbase unique name. ";
    private static final String CAPABILITIES_USE_LOLAP = "v5.useLocalOLAP";
    public static final String APPLIED = "isApplied";

    public ExpandMUNForLOLAP() {
        this.mName = "Convert Rootmember name to a 3-parts unique name for LOLAP.";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1067};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        BaseMember baseMember = (BaseMember)node;
        String un = baseMember.getExternalName();
        IHierarchy hierarchy = baseMember.getHierarchy();
        IDimension dimension = hierarchy.getDimension();
        try {
            baseMember.setPropertyValue("v5MemberUniqueName", un);
            un = UniqueNameGenerator.createUniqueName(dimension.getName(), hierarchy.getName(), UniqueNameParser.parserFirstIdentifier(un));
        }
        catch (UniqueNameParserException e) {
            XQEDebugLog.err.println(MSG_ERROR_PARSING_ESSBASE_UNIQUE_NAME + un);
        }
        baseMember.setPropertyValue("externalName", un);
        node.setPropertyValue(APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        boolean isApplied = false;
        Boolean propValue = (Boolean)node.getPropertyValue(APPLIED);
        if (propValue != null) {
            isApplied = propValue;
        }
        if (isApplied) {
            this.traceNodeCondition(status, "The transformation has been applied.", trace);
            return false;
        }
        IXQEQueryNode cogMDXQueryNode = node.getAncestorOfType(1002);
        if (cogMDXQueryNode != null) {
            IDataSourceCapabilities capabilities = ((MDXQuery)cogMDXQueryNode).getCapabilities();
            if (!capabilities.isSupported(CAPABILITIES_USE_LOLAP)) {
                this.traceNodeCondition(false, "Essbase external root member name doesn't need to be converted. ", trace);
                return false;
            }
            return false;
        }
        if (status) {
            this.traceNodeCondition(status, "The Rootmember needs to be converted for LOLAP.", trace);
        } else {
            this.traceNodeCondition(status, "The doesn't need to be converted for LOLAP.", trace);
        }
        return status;
    }
}

