/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.essbase;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.BaseProperty;
import com.cognos.xqe.ast.olap.CogMDXProperties;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.MDXStringConstant;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.essbase.EssbaseTransformation;

public class ResolveIntegerComparison
extends EssbaseTransformation {
    public static final String APPLIED = "isApplied";
    private static final String MSG_ERROR_PARSING_INTEGER_CONSTANT_STRING = "Error parsing integer string. ";

    public ResolveIntegerComparison() {
        this.mName = "Resolve Integer Type value comparison in essbase.";
        this.mPassNumbers = new int[]{52};
        this.mTypes = new int[]{1070};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode child1 = node.getChild(1);
        if (child1.getType() == 1127) {
            String stringValue = ((MDXStringConstant)child1).getConstantValue();
            IXQEQueryNode intNode = factory.createNode(1064);
            MDXNumericConstant numNode = (MDXNumericConstant)intNode;
            double value = 0.0;
            try {
                value = Double.parseDouble(stringValue);
            }
            catch (NumberFormatException e) {
                XQEDebugLog.err.println(MSG_ERROR_PARSING_INTEGER_CONSTANT_STRING + stringValue);
            }
            numNode.setConstantValue(value);
            child1.exchange(numNode);
        }
        node.setPropertyValue(APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        boolean isApplied = false;
        Boolean propValue = (Boolean)node.getPropertyValue(APPLIED);
        if (propValue != null) {
            isApplied = propValue;
        }
        if (isApplied) {
            this.traceNodeCondition(status, "The integer comparison has already been resolved.", trace);
            return false;
        }
        int operatorType = ((MDXComparisonOperator)node).getOperatorType();
        switch (operatorType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                BaseProperty baseProperty;
                IQueryItem md;
                if (node.getChild(0).getType() != 1016 || !((CogMDXProperties)node.getChild(0)).isNumericProperty() || (md = (baseProperty = (BaseProperty)node.getChild(0).getChild(0)).getPropertyMetadata()) == null || node.getChild(1).getType() != 1127) break;
                status = true;
                break;
            }
        }
        this.traceNodeCondition(status, "The comparison of integer type value exists.", trace);
        return status;
    }
}

