/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.essbase;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.essbase.EssbaseTransformation;

public class SetEssbaseExternalCalculatedMemberName
extends EssbaseTransformation {
    public SetEssbaseExternalCalculatedMemberName() {
        this.mName = "Set Essbase calculated member name.";
        this.mPassNumbers = new int[]{46, 52};
        this.mTypes = new int[]{1005};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXCalculatedMemberDefinition cmd = (MDXCalculatedMemberDefinition)node;
        String externalName = (String)cmd.getPropertyValue("externalName");
        if (externalName == null) {
            this.traceNodeCondition(true, "Essbase external calculated member name must be set for Java native providers. ", trace);
            return true;
        }
        this.traceNodeCondition(false, "Essbase external calculated member name already set. ", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXCalculatedMemberDefinition cmd = (MDXCalculatedMemberDefinition)node;
        String un = cmd.getUniqueName();
        cmd.setPropertyValue("externalName", un);
        cmd.setCustomUniqueName(un);
    }
}

