/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.essbase;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.essbase.EssbaseTransformation;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;

public class SetEssbaseExternalMemberName
extends EssbaseTransformation {
    private static final String MSG_ERROR_PARSING_ESSBASE_UNIQUE_NAME = "Error parsing essbase unique name. ";

    public SetEssbaseExternalMemberName() {
        this.mName = "Set Essbase level name which should be of the form [dim].[level]";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1067};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        IXQEQueryNode cogMDXQueryNode = node.getAncestorOfType(1002);
        IDataSourceCapabilities capabilities = ((MDXQuery)cogMDXQueryNode).getCapabilities();
        if (capabilities.isSupported("v5.useLocalOLAP") && !((MDXQuery)cogMDXQueryNode).getForceRemoteQueryProcessing()) {
            this.traceNodeCondition(false, "Essbase external member name transformation not required. ", trace);
            return false;
        }
        BaseMember bm = (BaseMember)node;
        String externalName = (String)bm.getPropertyValue("externalName");
        if (externalName != null) {
            try {
                String[] parts = UniqueNameParser.parse(externalName);
                if (parts.length > 2) {
                    this.traceNodeCondition(true, "Essbase external member name must have less than 2 parts for Java native providers. ", trace);
                    return true;
                }
            }
            catch (UniqueNameParserException e) {
                XQEDebugLog.err.println(MSG_ERROR_PARSING_ESSBASE_UNIQUE_NAME + externalName);
                this.traceNodeCondition(false, "Essbase external member name not formatted so this tranformation can set it. ", trace);
                return false;
            }
        }
        this.traceNodeCondition(false, "Essbase external member name already set okay. ", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        BaseMember baseMember = (BaseMember)node;
        String un = baseMember.getExternalName();
        try {
            String[] parts = UniqueNameParser.parse(un);
            baseMember.setPropertyValue("v5MemberUniqueName", un);
            un = UniqueNameGenerator.createUniqueName(parts[parts.length - 2], parts[parts.length - 1]);
            baseMember.setPropertyValue("externalName", un);
        }
        catch (UniqueNameParserException e) {
            XQEDebugLog.err.println(MSG_ERROR_PARSING_ESSBASE_UNIQUE_NAME + un);
        }
    }
}

