/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.essbase.direct;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSetAliasDefinition;
import com.cognos.xqe.ast.olap.MDXSetAliasReference;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.provider.essbase.direct.EssbaseDirectTransformation;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import java.util.ArrayList;
import java.util.List;

public class ConvertIIFInHeadToCalculatedMember
extends EssbaseDirectTransformation {
    public ConvertIIFInHeadToCalculatedMember() {
        this.mName = "Convert IIF Function within Head Function to a calculated Member.";
        this.mPassNumbers = new int[]{45};
        this.mTypes = new int[]{1042};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode child = node.getChild(1);
        IXQEQueryNode[] aliasRefs = child.getDescendantsOfType(1015, false);
        if (aliasRefs.length > 0) {
            for (IXQEQueryNode aliasRef : aliasRefs) {
                MDXSetAliasDefinition definition = ((MDXSetAliasReference)aliasRef).getDefinition();
                IXQEQueryNode parent = aliasRef.getParent();
                IXQEQueryNode definitionExpr = definition.getChild(0);
                IXQEQueryNode newChild = factory.deepCopyNode(definitionExpr);
                parent.exchangeChildNode(aliasRef, newChild);
                List<MDXSetAliasReference> saRefs = definition.getSetAliasRefs();
                saRefs.remove(aliasRef);
                if (saRefs.size() != 0) continue;
                definition.extract();
            }
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IHierarchy hierarchy = this.resolveDefaultMeasureHierarchy(mdxQuery, factory);
        AbstractMDXNode iifNode = (AbstractMDXNode)node.getChild(1);
        IXQEQueryNode newNode = factory.deepCopyNode(iifNode);
        MDXCalculatedMemberReference newCalcMember = MDXBuilder.buildMDXCalculatedMemberReference(factory, mdxQuery, hierarchy, "_CM", (AbstractMDXNode)newNode, SolveOrderUtil.getMaxMDXSolveOrder());
        node.exchangeChildNode(iifNode, MDXBuilder.coerceToNumericValueExpression(newCalcMember, factory));
    }

    private IHierarchy resolveDefaultMeasureHierarchy(MDXQuery mdxQuery, IXQENodeFactory factory) {
        IHierarchy hierarchy;
        ArrayList<BaseMember> projectedBaseMeasures = new ArrayList<BaseMember>();
        MDXEdge[] edges = mdxQuery.getEdges();
        for (int setIndex = 0; setIndex < edges.length; ++setIndex) {
            MDXEdge edge = edges[setIndex];
            IXQEQueryNode[] muns = edge.getDescendantsOfType(1067, false);
            for (int munIndex = 0; munIndex < muns.length; ++munIndex) {
                int measureIndex;
                BaseMember baseMember = (BaseMember)muns[munIndex];
                if (!baseMember.getHierarchy().getDimension().isMeasuresDimension() || baseMember.isValueExpressionOperand() || !edge.isProjectedDescendant(baseMember)) continue;
                for (measureIndex = 0; measureIndex < projectedBaseMeasures.size() && !baseMember.isSameExpression((BaseMember)projectedBaseMeasures.get(measureIndex), false); ++measureIndex) {
                }
                if (measureIndex != projectedBaseMeasures.size()) continue;
                projectedBaseMeasures.add(baseMember);
            }
        }
        if (projectedBaseMeasures.size() == 1) {
            IXQEQueryNode defaultMeasure = factory.deepCopyNode((IXQEQueryNode)projectedBaseMeasures.get(0));
            hierarchy = ((BaseMember)defaultMeasure).getHierarchy();
        } else {
            ICube cube = mdxQuery.getReferencedCube();
            hierarchy = cube.getMeasuresHierarchy();
        }
        return hierarchy;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode child;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        if (node.getNumberChildren() > 1 && (child = node.getChild(1)).getType() == 1085) {
            IXQEQueryNode[] aliasDefs = child.getDescendantsOfType(1004, false);
            if (aliasDefs.length > 0) {
                return false;
            }
            IXQEQueryNode[] aliasRefs = child.getDescendantsOfType(1015, false);
            if (aliasRefs.length > 0) {
                for (IXQEQueryNode aliasRef : aliasRefs) {
                    boolean isRequired = false;
                    Boolean propValue = (Boolean)aliasRef.getPropertyValue("required");
                    if (propValue != null) {
                        isRequired = propValue;
                    }
                    if (isRequired) {
                        throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_TemporarilyUnsupportedFeature, "Temporarily unsupported due to an Essbase bug if IIF function is in HEAD and refers to a set alias.");
                    }
                    status = true;
                }
            } else {
                status = true;
            }
        }
        if (status) {
            this.traceNodeCondition(status, "The Head function has a IIF child.", trace);
        } else {
            this.traceNodeCondition(status, "The Head function doesn't have a IIF child.", trace);
        }
        return status;
    }
}

