/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.essbase.direct;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXOrder;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.essbase.direct.EssbaseDirectTransformation;

public class ResolveOrderFunction
extends EssbaseDirectTransformation {
    public ResolveOrderFunction() {
        this.mName = "Resolve Order Function Type.";
        this.mPassNumbers = new int[]{52};
        this.mTypes = new int[]{1058};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXOrder order = (MDXOrder)node;
        int operatorType = order.getOrderingProperty();
        switch (operatorType) {
            case 0: {
                order.setOrderingProperty(1);
                break;
            }
            case 2: {
                order.setOrderingProperty(3);
                break;
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        int operatorType = ((MDXOrder)node).getOrderingProperty();
        switch (operatorType) {
            case 0: {
                status = true;
                break;
            }
            case 2: {
                status = true;
                break;
            }
        }
        this.traceNodeCondition(status, "The Unsupported order function ordering type exists.", trace);
        return status;
    }
}

