/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.ProviderTransformation;

public final class ApplyIncludeCalculatedMembersQueryHint
extends ProviderTransformation {
    private static final String ADDCALCULATEDMEMBERS_APPLIED = "AddCalculatedMembersApplied";
    private static final String[] PROVIDER_TYPES = new String[]{"YK", "M8", "M12", "M14", "M16", "M17", "M19", "XO", "MAZ", "X8", "XI", "RO", "X5"};

    public ApplyIncludeCalculatedMembersQueryHint() {
        super(PROVIDER_TYPES);
        this.mName = "Replace IncludeCalculatedMembers query hint by MDX AddCalculatedMembers function.";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1040, 1048, 1051, 1052, 1147};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode mdxAddCM = factory.createNode(1154);
        node.insertParent(mdxAddCM);
        node.setPropertyValue(ADDCALCULATEDMEMBERS_APPLIED, "true");
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery != null && mdxQuery.getIncludeCalculatedMembers()) {
            this.traceQueryCondition(true, "The node needs to be wrapped.", trace);
            return true;
        }
        this.traceQueryCondition(false, "The node does not need to be wrapped.", trace);
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        if (node.getPropertyValue(ADDCALCULATEDMEMBERS_APPLIED) != null) {
            this.traceNodeCondition(false, "The transformation has already been applied to this node.", trace);
            return false;
        }
        MDXHierInfo hierInfo = ((AbstractMDXSet)node).getHierarchyInfo();
        if (hierInfo.getNumProjectedHierarchies() != 1) {
            this.traceNodeCondition(false, "The set expression involves more than one hierarchy.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation needs to be applied to this node.", trace);
        return true;
    }
}

