/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.CogMDXScalarFunction;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.ProviderTransformation;
import com.cognos.xqe.util.pool.XQEIntegerPool;

public final class RenameScalarFunctions
extends ProviderTransformation {
    private static final String[] PROVIDER_TYPES = new String[]{"YK", "M8", "M12", "M14", "M16", "M17", "M19", "MAZ", "X5", "XO", "X8"};

    public RenameScalarFunctions() {
        super(PROVIDER_TYPES);
        this.mName = "Rename scalar functions for MSAS 2000, 2005 & 2008";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1144};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXScalarFunction fn = (CogMDXScalarFunction)node;
        int type = fn.getOperatorType();
        switch (type) {
            case 1: {
                fn.setOperatorMDX("VBA!ABS");
                break;
            }
            case 2: {
                fn.setOperatorMDX("VBA!ROUND");
                break;
            }
            case 3: {
                fn.setOperatorMDX("Excel!ROUNDDOWN");
                if (fn.getNumberChildren() >= 2) break;
                XQENodeFactory factory = environment.getNodeFactory();
                MDXNumericConstant roundfactor = (MDXNumericConstant)factory.createNode(1064);
                roundfactor.setConstantValue(XQEIntegerPool.getInteger(0));
                fn.addChild(roundfactor, 1);
                break;
            }
            case 4: {
                fn.setOperatorMDX("VBA!SQR");
                break;
            }
            case 5: {
                fn.setOperatorMDX("Excel!POWER");
                break;
            }
            case 6: {
                fn.setOperatorMDX("Excel!ROUNDUP");
                if (fn.getNumberChildren() >= 2) break;
                XQENodeFactory factory = environment.getNodeFactory();
                MDXNumericConstant roundfactor = (MDXNumericConstant)factory.createNode(1064);
                roundfactor.setConstantValue(XQEIntegerPool.getInteger(0));
                fn.addChild(roundfactor, 1);
                break;
            }
            case 7: {
                fn.setOperatorMDX("VBA!EXP");
                break;
            }
            case 8: {
                fn.setOperatorMDX("Excel!LN");
                break;
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        String fnMDX = ((CogMDXScalarFunction)node).getMDXTextName();
        if (!(fnMDX.equals("ABS") || fnMDX.equals("ROUND") || fnMDX.equals("ROUNDDOWN") || fnMDX.equals("SQRT") || fnMDX.equals("POWER") || fnMDX.equals("ROUNDUP") || fnMDX.equals("EXP") || fnMDX.equals("LN"))) {
            this.traceNodeCondition(false, "This scalar function does not need to be renamed.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This scalar function must be renamed.", trace);
        return true;
    }
}

