/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas.msas2000;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.ProviderTransformation;

public class OptimizeAggregateOnCrossjoinSets
extends ProviderTransformation {
    public OptimizeAggregateOnCrossjoinSets() {
        super(new String[]{"XO"});
        this.mName = "OptimizeAggregateOnCrossjoinSets.";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{1060};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXCrossjoin crossjoin = (MDXCrossjoin)node.getChild(0);
        MDXSummaryFunction newSummary = (MDXSummaryFunction)factory.createNode(1060);
        crossjoin.getChild(1).move(newSummary);
        newSummary.setSummaryType(((MDXSummaryFunction)node).getSummaryType());
        if (node.getNumberChildren() > 1) {
            node.getChild(1).move(newSummary);
        }
        node.exchangeChildNode(crossjoin, crossjoin.detachChild(0));
        node.addChild(newSummary);
    }

    protected boolean isValidSetForCrossjoinReplacement(AbstractMDXSet set, boolean firstCrossjoin) {
        switch (set.getType()) {
            case 1039: {
                return set.getNumberChildren() != 1 || !set.getParent().isOfCategory(1030);
            }
            case 1041: 
            case 1053: 
            case 1058: 
            case 1069: {
                return firstCrossjoin;
            }
            case 1030: {
                if (!this.isValidSetForCrossjoinReplacement((AbstractMDXSet)set.getChild(0), firstCrossjoin) || !this.isValidSetForCrossjoinReplacement((AbstractMDXSet)set.getChild(1), false)) break;
                return true;
            }
        }
        boolean bResult = true;
        for (int i = 0; i < set.getNumberChildren() && bResult; ++i) {
            if (!set.getChild(i).isOfCategory(1021)) continue;
            bResult &= this.isValidSetForCrossjoinReplacement((AbstractMDXSet)set.getChild(i), firstCrossjoin);
        }
        return bResult;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXSummaryFunctionTypeEnum type = ((MDXSummaryFunction)node).getSummaryType();
        if (type != MDXSummaryFunctionTypeEnum.SUM && type != MDXSummaryFunctionTypeEnum.MINIMUM && type != MDXSummaryFunctionTypeEnum.MAXIMUM) {
            this.traceNodeCondition(false, "The current aggregation type does not support cascading", trace);
            return false;
        }
        if (!node.getChild(0).isOfCategory(1030)) {
            this.traceNodeCondition(false, "The first operand of the aggregate is not a crossjoin", trace);
            return false;
        }
        if (!this.isValidSetForCrossjoinReplacement((AbstractMDXSet)node.getChild(0), true)) {
            this.traceNodeCondition(false, "One of crossjoin children is not applicable to this transformation", trace);
            return false;
        }
        return true;
    }
}

