/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas.msas2005;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.msas.msas2005.YukonTransformation;

public final class SetCountFormatOnCalculatedMember
extends YukonTransformation {
    public SetCountFormatOnCalculatedMember() {
        this.mName = "Set Count Format on Calculated Member.";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1005};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.setPropertyValue("FORMAT_STRING", "#");
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        node.throwOnInvalidChildCategories();
        if (node.getPropertyValue("FORMAT_STRING") != null || node.getChild(0).getPropertyValue("FORMAT_STRING") != null) {
            this.traceNodeCondition(false, "The target node has a format property already set.", trace);
            return false;
        }
        IXQEQueryNode child = node.getChild(0);
        if (child.isOfCategory(1085)) {
            if (!this.checkIIFOperands(child)) {
                this.traceNodeCondition(false, "The MDXNumericIIF expression does not return an operand that needs a number format.", trace);
                return false;
            }
            this.traceNodeCondition(false, "The MDXNumericIIF expression returns an operand that needs a number format.", trace);
            return true;
        }
        String format = (String)child.getPropertyValue("FORMAT_STRING");
        if ("#".equals(format)) {
            this.traceNodeCondition(true, "The target node is an expression returning a number format.", trace);
            return true;
        }
        if (!child.isOfCategories(new int[]{1087, 1100})) {
            this.traceNodeCondition(false, "The target node is not a Count or Rank expression.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The target node is a Count or Rank expression that needs a number format.", trace);
        return true;
    }

    private boolean checkIIFOperands(IXQEQueryNode node) {
        node.throwOnInvalidChildCategories();
        boolean operand1 = false;
        IXQEQueryNode trueOperand = node.getChild(1);
        if (trueOperand.isOfCategory(1085)) {
            operand1 = this.checkIIFOperands(trueOperand);
        } else {
            String format = (String)trueOperand.getPropertyValue("FORMAT_STRING");
            if ("#".equals(format)) {
                operand1 = true;
            }
            if (trueOperand.isOfCategories(new int[]{1087, 1100})) {
                operand1 = true;
            }
            if (!operand1) {
                return false;
            }
        }
        boolean operand2 = false;
        IXQEQueryNode falseOperand = node.getChild(2);
        if (falseOperand.isOfCategory(1085)) {
            operand2 = this.checkIIFOperands(falseOperand);
        } else {
            String format = (String)falseOperand.getPropertyValue("FORMAT_STRING");
            if ("#".equals(format)) {
                operand2 = true;
            }
            if (falseOperand.isOfCategories(new int[]{1087, 1100})) {
                operand2 = true;
            }
            if (!operand2) {
                return false;
            }
        }
        return operand1 && operand2;
    }
}

