/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.powercube;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXHierarchy;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class ResetIsNoMemberPropOnMDXDefaultMemberWhenNotRequired
extends Transformation {
    public static final int IS_NO_MEMBER = 0;
    public static final int IS_NOT_NO_MEMBER = 1;
    public static final int DATASOURCE_DOES_NOT_REQUIRES_NO_MEMBER = 2;
    public static final int DEFAULTMEMBER_IS_FROM_DEFAULTHIERARCHY = 3;

    public ResetIsNoMemberPropOnMDXDefaultMemberWhenNotRequired() {
        this.mName = "Reset IsNoMember property on MDXDefaultMember when not required.";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1077};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXDefaultMember mdxDefaultMember = (MDXDefaultMember)node;
        mdxDefaultMember.setPropertyIsNoMember(false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXDefaultMember defaultMember = (MDXDefaultMember)node;
        int status = ResetIsNoMemberPropOnMDXDefaultMemberWhenNotRequired.isNoMemberDefaultMember(defaultMember);
        if (status == 1) {
            this.traceQueryCondition(false, "Default Member is not NoMember.", trace);
            return false;
        }
        if (status == 2) {
            this.traceQueryCondition(true, "DataSource does not require noMember defaultMember.", trace);
            return true;
        }
        if (status == 3) {
            this.traceQueryCondition(true, "Default Member is from default hierarchy.", trace);
            return true;
        }
        this.traceQueryCondition(false, "Default Member is a NoMember and its use is acceptable.", trace);
        return false;
    }

    public static int isNoMemberDefaultMember(MDXDefaultMember defaultMember) {
        boolean status = defaultMember.getPropertyIsNoMember();
        if (!status) {
            return 1;
        }
        MDXQuery mdxQuery = (MDXQuery)defaultMember.getAncestorOfType(1002);
        if (mdxQuery == null) {
            return 0;
        }
        boolean bl = status = !mdxQuery.dataSourceRequiresNoMemberDefaultMember();
        if (status) {
            return 2;
        }
        AbstractMDXHierarchy hierarchy = (AbstractMDXHierarchy)defaultMember.getChild(0);
        status = hierarchy.getHierarchy().equals(hierarchy.getHierarchy().getDimension().getDefaultHierarchy());
        if (status) {
            return 3;
        }
        return 0;
    }
}

