/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.powercube;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.powercube.PowerCubeTransformation;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqebifw.adminconsole.qsat.server.OptionsXMLProcessor;

public class SetPowerCubeMemberExternalName
extends PowerCubeTransformation {
    private static final String DEFAULT_HIERARCHY_BRACKETS = "[]";
    private static final String AT_MEMBER = "[@MEMBER].";
    private static final String AT_FILLER_MEMBER = "[@FILLER_MEMBER].";
    private static final String AT_MEMBER_NO_BRACKETS = "@MEMBER";

    public SetPowerCubeMemberExternalName() {
        this.mName = "Set PowerCube calculated measure name which should be [<MeasureDimExternalName>].[].[<CalcName>]";
        this.mPassNumbers = new int[]{2, 46};
        this.mTypes = new int[]{1067};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery.getUseLocalQueryProcessing()) {
            this.traceNodeCondition(false, "Using LOLAP to process this query.", trace);
            return false;
        }
        BaseMember bm = (BaseMember)node;
        ILevel level = bm.getLevel();
        if (level == null) {
            this.traceNodeCondition(false, "PowerCube member does not have a level", trace);
            return false;
        }
        String externalName = bm.getExternalName();
        if (!this.passesMunPrefixCondition(externalName, AT_MEMBER, trace)) {
            return false;
        }
        if (!this.passesMunPrefixCondition(externalName, AT_FILLER_MEMBER, trace)) {
            return false;
        }
        if (level.getHierarchy().getDimension().isMeasuresDimension()) {
            this.traceNodeCondition(false, "PowerCube external member translation is not applied to measure dimension", trace);
            return false;
        }
        this.traceNodeCondition(true, "PowerCube external member name will be translated.", trace);
        return true;
    }

    private boolean passesMunPrefixCondition(String name, String prefix, XQETrace trace) {
        if (!name.startsWith(prefix) && name.contains(prefix)) {
            this.traceNodeCondition(false, "PowerCube external member name contains " + prefix + ", but it does not start with " + prefix, trace);
            return false;
        }
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        BaseMember bm = (BaseMember)node;
        String originalName = bm.getExternalName();
        String externalName = SetPowerCubeMemberExternalName.buildPowerCubeMemberExternalName(originalName, bm.getLevel().getHierarchy(), false);
        bm.bindExternalName(externalName);
    }

    public static String buildPowerCubeMemberExternalName(String originalName, IHierarchy hier, boolean xmlEncode) {
        int bracketPos;
        String hun;
        String externalName = originalName;
        if (!externalName.contains(AT_MEMBER) && !externalName.contains(AT_FILLER_MEMBER)) {
            String[] parts = null;
            try {
                parts = UniqueNameParser.parse(externalName);
            }
            catch (UniqueNameParserException e) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_ParsingException, (Throwable)e, externalName);
            }
            if (parts.length > 1) {
                externalName = UniqueNameGenerator.createUniqueName(AT_MEMBER_NO_BRACKETS, UniqueNameParser.escapeSquareBrackets(parts[parts.length - 1]));
            }
        }
        StringBuilder buffer = new StringBuilder();
        String sMassagedHUN = hun = hier.getUniqueName();
        if (xmlEncode) {
            sMassagedHUN = OptionsXMLProcessor.xmlEncode(hun);
        }
        if (sMassagedHUN.substring(bracketPos = sMassagedHUN.length() - DEFAULT_HIERARCHY_BRACKETS.length()).equals(DEFAULT_HIERARCHY_BRACKETS)) {
            buffer.append(sMassagedHUN.substring(0, bracketPos));
        } else {
            buffer.append(sMassagedHUN);
        }
        buffer.append(".");
        buffer.append(externalName);
        return buffer.toString();
    }
}

