/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.sapbw;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeAbstractDetailFilter;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.sapbw.SAPBWTransformation;
import java.util.List;

public final class MarkVDFForBWDBOnly
extends SAPBWTransformation {
    public static final String PROP_APPLYBWDBONLY = "applyBWDBOnlyTransformation";

    public MarkVDFForBWDBOnly() {
        this.mName = "Mard whether the Valude Detail Filter should be modified to BW specific MDX.";
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{1095};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        mdxQuery.setPropertyValue(PROP_APPLYBWDBONLY, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            this.traceNodeCondition(false, "Not a BW query.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery.getUseLocalQueryProcessing()) {
            this.traceNodeCondition(false, "The query is against local engine.", trace);
            return false;
        }
        if (mdxQuery.getPropertyValue(PROP_APPLYBWDBONLY) != null) {
            this.traceNodeCondition(false, "The transformation has already been applied.", trace);
            return false;
        }
        TNodeAbstractDetailFilter tNode = (TNodeAbstractDetailFilter)node;
        if (!tNode.getPostAutoAggregation()) {
            this.traceNodeCondition(false, "The Detail Filter timing is before auto aggregation.", trace);
            return false;
        }
        String timing = tNode.getPostAutoAggregationTiming(mdxQuery);
        if (!timing.equals("reportDetails")) {
            this.traceNodeCondition(false, "The Detail Filter post auto aggregation timing is not set to 'reportDetails'", trace);
            return false;
        }
        MDXEdge[] edges = mdxQuery.getEdges();
        boolean queryProjectsNonMeasureHierarchy = false;
        for (int i = 0; i < edges.length; ++i) {
            MDXHierInfo edgeHierInfo = edges[i].getHierarchyInfo();
            if (edgeHierInfo.getNumberOfNonMeasureHierarchiesProjected() == 0) continue;
            queryProjectsNonMeasureHierarchy = true;
        }
        if (!queryProjectsNonMeasureHierarchy) {
            this.traceNodeCondition(false, "The edges of the MDXQuery do not project any non-Measure hierarchies.", trace);
            return false;
        }
        if (!mdxQuery.isListReport()) {
            this.traceNodeCondition(false, "Not a list report.", trace);
            return false;
        }
        int[] types = new int[]{1179, 1011};
        if (mdxQuery.getDescendantsOfCategories(types, true, true, true, false, false).size() > 1) {
            this.traceNodeCondition(false, "There is other filter in the MDXQuery.", trace);
            return false;
        }
        IXQEQueryNode edge = mdxQuery.getFirstChildByType(1006);
        List<IXQEQueryNode> mdxValues = edge.getChild(0).getDescendantsOfCategory(1061, false);
        if (mdxValues != null && mdxValues.size() != 0) {
            this.traceNodeCondition(false, "The edge has value expression.", trace);
            return false;
        }
        IXQEQueryNode[] cogMDXGroups = edge.getDescendantsOfType(1027, true);
        MDXHierInfo firstChildHierInfo = null;
        MDXHierInfo secondChildHierInfo = null;
        AbstractMDXSet firstChild = null;
        AbstractMDXSet secondChild = null;
        for (int i = 0; i < cogMDXGroups.length; ++i) {
            if (cogMDXGroups[i].getNumberChildren() != 2) continue;
            firstChild = (AbstractMDXSet)cogMDXGroups[i].getChild(0);
            secondChild = (AbstractMDXSet)cogMDXGroups[i].getChild(1);
            firstChildHierInfo = firstChild.getHierarchyInfo();
            secondChildHierInfo = secondChild.getHierarchyInfo();
            if (firstChildHierInfo != null && firstChildHierInfo.projectedHierarchiesOverlap(secondChildHierInfo)) {
                this.traceNodeCondition(false, "The hierarch of the CogMdxGroup overlaps.", trace);
                return false;
            }
            List<IHierarchy> hierarchies = firstChildHierInfo.getProjectedHierarchies();
            for (IHierarchy hierarchy : hierarchies) {
                if (!secondChild.isContextDependent(hierarchy)) continue;
                this.traceNodeCondition(false, "The second child of CogMDXGroup is context dependent on the first child.", trace);
                return false;
            }
        }
        this.traceNodeCondition(true, "The transformation will be applied to the target node.", trace);
        return true;
    }
}

