/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.sapbw;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValueItem;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.sapbw.SAPBWTransformation;
import com.cognos.xqe.util.UniqueNameParser;
import java.util.Iterator;
import java.util.List;

public class SetSAPVariables
extends SAPBWTransformation {
    public SetSAPVariables() {
        this.mName = "Set a query's SAP variables.";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1007};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean hasDatasourceParameters = false;
        if (super.passesNodeCondition(node, environment)) {
            RequestEnvironment requestEnvironment = (RequestEnvironment)environment.getRequestEnvironment();
            Parameters parameters = requestEnvironment.getRequestParameters();
            XQETrace trace = environment.getTrace();
            MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
            if (mdxQuery.getNumberOfEdges() == 0) {
                this.traceNodeCondition(false, "The MDX is empty.", trace);
                return false;
            }
            if (mdxQuery.getHaveVariableValuesBeenSet()) {
                this.traceNodeCondition(false, "Transformation has already been applied.", trace);
                return false;
            }
            for (Parameter parameter : parameters.values()) {
                hasDatasourceParameters = hasDatasourceParameters || parameter.isDataSourceParameter();
            }
            if (hasDatasourceParameters) {
                this.traceNodeCondition(true, "Has datasource parameters.", trace);
            } else {
                this.traceNodeCondition(false, "Has no datasource parameters.", trace);
            }
        }
        return hasDatasourceParameters;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXFromCube mdxFromCube = (MDXFromCube)node;
        ICube cube = mdxFromCube.getCube();
        List<IVariable> variables = cube.getVariables();
        MDXQuery mdxQuery = (MDXQuery)mdxFromCube.getAncestorOfType(1002);
        RequestEnvironment requestEnvironment = (RequestEnvironment)environment.getRequestEnvironment();
        Parameters parameters = requestEnvironment.getRequestParameters();
        mdxQuery.setHaveVariableValuesBeenSet(true);
        for (IVariable variable : variables) {
            String variableUniqueName = variable.getDisambiguatedUniqueName(environment.getMetadataConnection().getCubes(), cube);
            Parameter parameter = parameters.getParameter(variableUniqueName);
            if (parameter == null) {
                parameter = parameters.getParameter(variable.getUniqueName());
            }
            if (parameter == null) continue;
            MDXQuery mdQuerySpec = (MDXQuery)node.getAncestorOfType(1002);
            parameter.bindToRequest((RequestEnvironment)environment.getRequestEnvironment());
            Iterator valueIt = parameter.getParameterValueItems().iterator();
            while (valueIt.hasNext()) {
                StringBuilder buffer = new StringBuilder();
                String variableName = null;
                try {
                    variableName = UniqueNameParser.parseLastIdentifier(parameter.getName());
                }
                catch (Exception e) {
                    throw new XQERuntimeException(XQEMessageKeys.PVD_InvalidProviderIdentifier, (Throwable)e, parameter.getName());
                }
                buffer.append('[');
                buffer.append(variableName);
                buffer.append(']');
                ParameterValueItem parameterValueItem = (ParameterValueItem)valueIt.next();
                parameterValueItem.asSAPVariablesString(buffer, environment);
                mdQuerySpec.addSAPVariable(buffer.toString());
            }
        }
    }
}

