/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.tm1;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.tm1.TM1Transformation;
import java.util.Iterator;
import java.util.List;

public final class SetNullSuppressionQueryHint
extends TM1Transformation {
    public SetNullSuppressionQueryHint() {
        this.mName = "Set Null Suppression Query Hint";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ((MDXQuery)node).setPropertyValue("nullSuppressionAcrossEdges", Boolean.FALSE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        if (null != ((MDXQuery)node).getNullSuppressionQueryHint()) {
            this.traceQueryCondition(false, "The 'nullSuppressionAcrossEdges' flag is already set on the MDXQuery node.", trace);
            return false;
        }
        MDXEdge[] edges = ((MDXQuery)node).getEdges();
        boolean bFoundNonEmpty = false;
        boolean bFoundNonEmptyOff = false;
        boolean bFoundNonMeasureDim = false;
        for (int i = 0; i < edges.length; ++i) {
            IHierarchy h;
            IDimension dim;
            MDXHierInfo hierInfo = edges[i].getHierarchyInfo();
            List<IHierarchy> projectedHierarchies = hierInfo.getProjectedHierarchies();
            bFoundNonMeasureDim = false;
            Iterator<IHierarchy> iterator = projectedHierarchies.iterator();
            while (iterator.hasNext() && !(bFoundNonMeasureDim = !(dim = (h = iterator.next()).getDimension()).isMeasuresDimension())) {
            }
            if (!bFoundNonMeasureDim) continue;
            boolean bNonEmpty = edges[i].getMDXNonEmptyProperty();
            if (bNonEmpty) {
                bFoundNonEmpty = true;
                continue;
            }
            bFoundNonEmptyOff = true;
        }
        if (bFoundNonEmpty && bFoundNonEmptyOff) {
            this.traceQueryCondition(true, "The MDXQuery node has the 'nullSuppressionAcrossEdges' flag set to false.", trace);
            return true;
        }
        this.traceQueryCondition(true, "The MDXQuery node has the 'nullSuppressionAcrossEdges' flag unset.", trace);
        return false;
    }
}

