/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXIntersect;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.TNodeAbstractMDXNode;
import com.cognos.xqe.ast.olap.TNodeApplyMDFOnSingleHierarchyToSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import java.util.List;

public final class AddCombinedAggrForMDFAndSLOnRefHierToSlicer
extends Transformation {
    public AddCombinedAggrForMDFAndSLOnRefHierToSlicer() {
        this.mName = "Add Aggregation for V5 Slicer On Not Projected Hierarchy To MDX Slicer.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1193};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        AbstractMDXSet expression = (AbstractMDXSet)node.getChild(0).getChild(1);
        MDXDimensionLine dimLine = mdxQuery.getDimensionLine();
        MDXTuple dimLineTuple = (MDXTuple)dimLine.getChild(0);
        MDXHierInfo targetHierInfo = expression.getHierarchyInfo();
        IHierarchy hierarchy = targetHierInfo.getProjectedHierarchy(0);
        for (IXQEQueryNode tupleMember : dimLineTuple.getChildren()) {
            AbstractMDXMember currMember = (AbstractMDXMember)tupleMember;
            if (!currMember.getHierarchy().equals(hierarchy)) continue;
            if (currMember.getType() == 1013) {
                MDXCalculatedMemberDefinition definition = ((MDXCalculatedMemberReference)currMember).getDefinition();
                AbstractMDXSet aggrSet = (AbstractMDXSet)definition.getChild(0).getChild(0);
                ILevel aggrSetLevel = aggrSet.getLevelInfo().getLowestProjectedLevel(hierarchy);
                ILevel expreLevel = expression.getLevelInfo().getLowestProjectedLevel(hierarchy);
                AbstractMDXSet newAggrSet = null;
                AbstractMDXSet newExpression = null;
                if (aggrSetLevel.getIndex() != expreLevel.getIndex()) {
                    if (aggrSetLevel.getIndex() < expreLevel.getIndex()) {
                        newAggrSet = MDXBuilder.generateLeafMembersToLevel(factory, mdxQuery, aggrSet, expreLevel);
                        newExpression = (AbstractMDXSet)expression.detach();
                    } else {
                        newExpression = MDXBuilder.generateLeafMembersToLevel(factory, mdxQuery, expression, aggrSetLevel);
                        newAggrSet = (AbstractMDXSet)aggrSet.detach();
                    }
                } else {
                    newAggrSet = (AbstractMDXSet)aggrSet.detach();
                    newExpression = (AbstractMDXSet)expression.detach();
                }
                MDXIntersect intersect = (MDXIntersect)factory.createNode(1038);
                intersect.addChild(newAggrSet);
                intersect.addChild(newExpression);
                intersect.setPropertyValue("DFSLAggrSet", Boolean.TRUE);
                definition.getChild(0).addChild(intersect, 0);
                break;
            }
            AbstractMDXSet set = (AbstractMDXSet)factory.createNode(1039);
            set.addChild(currMember);
            ILevel setLevel = set.getLevelInfo().getLowestProjectedLevel(hierarchy);
            ILevel expreLevel = expression.getLevelInfo().getLowestProjectedLevel(hierarchy);
            AbstractMDXSet newSet = null;
            AbstractMDXSet newExpression = null;
            if (setLevel.getIndex() != expreLevel.getIndex()) {
                if (setLevel.getIndex() < expreLevel.getIndex()) {
                    newSet = MDXBuilder.generateLeafMembersToLevel(factory, mdxQuery, set, expreLevel);
                    currMember.detach();
                } else {
                    newExpression = MDXBuilder.generateLeafMembersToLevel(factory, mdxQuery, (AbstractMDXSet)expression.detach(), expreLevel);
                    expression.detach();
                }
            }
            MDXIntersect intersect = (MDXIntersect)factory.createNode(1038);
            intersect.addChild(newSet);
            intersect.addChild(newExpression);
            intersect.setPropertyValue("DFSLAggrSet", Boolean.TRUE);
            MDXSummaryFunction aggrExpr = (MDXSummaryFunction)factory.createNode(1060);
            aggrExpr.setSummaryType(MDXSummaryFunctionTypeEnum.AGGREGATE);
            aggrExpr.addChild(intersect);
            MDXCalculatedMemberReference cm = MDXBuilder.buildMDXCalculatedMemberReference(factory, mdxQuery, hierarchy, "_SL", aggrExpr, SolveOrderUtil.getCubeCalcSolveOrder());
            dimLineTuple.addChild(cm);
            break;
        }
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        String reaggregationHostName = DFSLAggrUtil.getReaggregationHostName((TNodeAbstractMDXNode)node);
        if (reaggregationHostName == null || reaggregationHostName.compareTo("reaggregationHostDimensionLine") != 0) {
            this.traceNodeCondition(false, "The TNodeMDFOnSingleRefHierarchy is not set to be applied to dimension line.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The TNodeMDFOnSingleRefHierarchy node has invalid child nodes.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            node.throwInternalError("Internal Error.");
        }
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode[] tNodes = mdxQuery.getDescendantsOfType(1018, false);
        if (tNodes.length > 0) {
            for (IXQEQueryNode tNode : tNodes) {
                IXQEQueryNode tNodeMemberDetailFilter;
                List<Integer> detailFilterIds = ((TNodeApplyMDFOnSingleHierarchyToSet)tNode).getDetailFilterIds();
                if (detailFilterIds.isEmpty() || (tNodeMemberDetailFilter = (IXQEQueryNode)factory.getNodeIndex().getNodeByID(detailFilterIds.get(0))).getType() != 1193 || tNodeMemberDetailFilter != node) continue;
                this.traceNodeCondition(false, "At least one TNodeApplyMDFOnSingleHierarchyToSet requires to be applied first.", trace);
                return false;
            }
        }
        if (node.getPropertyValue("DistributeMDFToUnprojectedReferences") != Boolean.TRUE) {
            this.traceNodeCondition(false, "The TNodeMDFOnSingleRefHierarchy has not been distributed yet.", trace);
            return false;
        }
        MDXDimensionLine dimLine = mdxQuery.getDimensionLine();
        if (dimLine == null) {
            this.traceNodeCondition(false, "The MDXDimensionLine has not been created yet.", trace);
            return false;
        }
        if (dimLine.getNumberChildren() != 1 || !dimLine.getChild(0).isOfCategory(1068)) {
            this.traceNodeCondition(false, "The MDXDimensionLine node does not contain a single MDXTuple child node.", trace);
            return false;
        }
        MDXTuple dimLineTuple = (MDXTuple)dimLine.getChild(0);
        AbstractMDXNode expression = (AbstractMDXNode)node.getChild(0).getChild(1);
        MDXHierInfo slicerHierInfo = dimLineTuple.getHierarchyInfo();
        MDXHierInfo targetHierInfo = expression.getHierarchyInfo();
        if (!targetHierInfo.projectedHierarchiesOverlap(slicerHierInfo)) {
            this.traceNodeCondition(false, "The the target node does not apply to anyhierarchy that is already projected on the dimension line.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The first child of the target TNodeAbstractSlicer node projectsa hierarchy that is not already projected on the dimension line.", trace);
        return true;
    }
}

