/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXNamedSetDefinition;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.TNodeApplyMDFOnSingleHierarchyToSet;
import com.cognos.xqe.ast.olap.TNodeMDFOnSingleRefHierarchy;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.optimization.ReplaceTNodeTrueFalse;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.AddAggrForSLOnProjHierToSlicer;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DistributeMDFToPreMDXFilteringSets;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.List;

public final class DistributeMDFToUnprojectedReferences
extends Transformation {
    public static final String PROPERTY_TRANSFORMATION_APPLIED = "DistributeMDFToUnprojectedReferences";
    private int[] targetSetTypes = new int[]{1039, 1040, 1048, 1052, 1044, 1045, 1075, 1051, 1074, 1014, 1148};

    public DistributeMDFToUnprojectedReferences() {
        this.mName = "Distribute MDF to Unprojected Referneces.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1193};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        TNodeMDFOnSingleRefHierarchy tNodeMDF = (TNodeMDFOnSingleRefHierarchy)node;
        XQENodeFactory factory = environment.getNodeFactory();
        AbstractMDXSet rightFilterSet = (AbstractMDXSet)tNodeMDF.getChild(0).getChild(1);
        MDXLevelInfo mdfLevelInfo = rightFilterSet.getLevelInfo();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (rightFilterSet.getType() == 1145) {
            MDXQuery query = (MDXQuery)tNodeMDF.getAncestorOfCategory(1002);
            ReplaceTNodeTrueFalse.clearQuery(factory, query);
            AddAggrForSLOnProjHierToSlicer.emptySetInFilteringExpressionWarning(environment, tNodeMDF.getOriginalExpression());
            return;
        }
        IHierarchy hierarchy = mdfLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
        IXQEQueryNode[] tuples = mdxQuery.getDescendantsOfType(1069, false);
        List<AbstractMDXNode> referencedSetExpressions = mdxQuery.getDescendantsOfTypes(this.targetSetTypes, true, true, true, true, false);
        for (IXQEQueryNode tuple : tuples) {
            this.updateTuple((MDXTuple)tuple, tNodeMDF, mdfLevelInfo, hierarchy, factory);
        }
        for (AbstractMDXNode set : referencedSetExpressions) {
            MDXNamedSetDefinition ancestorNamedSetDefinition;
            if (((AbstractMDXSet)set).isEmpty() || set.isOfCategory(1014) && !((MDXNamedSetReference)set).getDefinition().getDBNamedSet() || (ancestorNamedSetDefinition = (MDXNamedSetDefinition)set.getAncestorOfType(1003)) != null && ancestorNamedSetDefinition.getDBNamedSet() || !DistributeMDFToPreMDXFilteringSets.isValidTargetSetNode((AbstractMDXSet)set)) continue;
            this.updateSet((AbstractMDXSet)set, tNodeMDF, hierarchy, factory);
        }
        tNodeMDF.setPropertyValue(PROPERTY_TRANSFORMATION_APPLIED, Boolean.TRUE);
    }

    public void updateSet(AbstractMDXSet set, TNodeMDFOnSingleRefHierarchy tNodeMDF, IHierarchy hierarchy, IXQENodeFactory factory) {
        MDXHierInfo hierInfo = set.getHierarchyInfo();
        if (!hierInfo.projectsHierarchy(hierarchy)) {
            return;
        }
        if (set.getAncestorOfCategory(1018) != null) {
            return;
        }
        if (set.getType() == 1039) {
            DistributeMDFToPreMDXFilteringSets.addTNodeToMDXSet(factory, (MDXSet)set, tNodeMDF.getId());
        } else {
            TNodeApplyMDFOnSingleHierarchyToSet tNode = (TNodeApplyMDFOnSingleHierarchyToSet)factory.createNode(1018);
            tNode.addDetailFilterId(tNodeMDF.getId());
            set.insertParent(tNode);
        }
    }

    public void updateTuple(MDXTuple tuple, TNodeMDFOnSingleRefHierarchy tNodeMDF, MDXLevelInfo mdfLevelInfo, IHierarchy hierarchy, IXQENodeFactory factory) {
        if (!tuple.isValueExpressionOperand()) {
            return;
        }
        MDXLevelInfo tupleLevelInfo = tuple.getLevelInfo();
        if (!tupleLevelInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) {
            return;
        }
        if (tuple.getAncestorOfCategory(1018) != null) {
            return;
        }
        AbstractMDXSet rightFilterSet = (AbstractMDXSet)tNodeMDF.getChild(0).getChild(1);
        for (IXQEQueryNode child : tuple.getChildren()) {
            AbstractMDXMember member;
            if (child.getType() == 1076 || !(member = (AbstractMDXMember)child).getHierarchy().equals(hierarchy)) continue;
            if (rightFilterSet.getType() == 1039 && rightFilterSet.getNumberChildren() == 1 && rightFilterSet.getChild(0).isSameExpression(member, false)) {
                return;
            }
            AbstractMDXSet slicerSet = (AbstractMDXSet)factory.deepCopyNode(tNodeMDF.getChild(0).getChild(1));
            MDXQuery mdxQuery = (MDXQuery)tNodeMDF.getAncestorOfType(1002);
            ILevel lowestProjectedLevel = tupleLevelInfo.getLowestProjectedLevel(hierarchy);
            ILevel lowestReferencedLevel = mdfLevelInfo.getLowestProjectedLevel(hierarchy);
            if (lowestProjectedLevel.getIndex() > lowestReferencedLevel.getIndex()) {
                lowestReferencedLevel = lowestProjectedLevel;
            }
            slicerSet = MDXBuilder.generateLeafMembersToLevel(factory, mdxQuery, slicerSet, lowestReferencedLevel);
            MDXCalculatedMemberReference cm = AddAggrForSLOnProjHierToSlicer.buildCalculation(slicerSet, tupleLevelInfo, lowestReferencedLevel, mdxQuery, tNodeMDF, factory);
            if (tuple.getHierarchyInfo().projectsHierarchy(cm.getHierarchy())) {
                return;
            }
            tuple.addChild(cm);
            break;
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        TNodeMDFOnSingleRefHierarchy tNodeMDF = (TNodeMDFOnSingleRefHierarchy)node;
        tNodeMDF.throwOnInvalidChildCategories();
        if (tNodeMDF.getPropertyValue(PROPERTY_TRANSFORMATION_APPLIED) == Boolean.TRUE) {
            this.traceNodeCondition(false, "The transformation was already applied to this node.", trace);
            return false;
        }
        String reaggregationHostName = DFSLAggrUtil.getReaggregationHostName(tNodeMDF);
        if (reaggregationHostName == null || reaggregationHostName.compareTo("reaggregationHostDimensionLine") != 0) {
            this.traceNodeCondition(false, "The MDF is not set to be applied to dimension line.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)tNodeMDF.getAncestorOfType(1002);
        IXQEQueryNode[] cogMDXDetailFilterNodes = mdxQuery.getDescendantsOfType(1010, false);
        if (cogMDXDetailFilterNodes.length > 0) {
            this.traceNodeCondition(false, "The query contains CogMDXDetailFilter nodes that have not yet been categorized.", trace);
            return false;
        }
        if (mdxQuery.getDescendantsOfType(1097, false).length > 0) {
            this.traceNodeCondition(false, "The query contains slicers on unreferenced hierarchies.", trace);
            return false;
        }
        if (mdxQuery.getDescendantsOfType(1098, false).length > 0) {
            this.traceNodeCondition(false, "The query contains slicers on projected hierarchies.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation has not yet been applied to this node.", trace);
        return true;
    }
}

