/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;

public final class FlagApplyAggrForVDFToQuery
extends Transformation {
    public FlagApplyAggrForVDFToQuery() {
        this.mName = "Flag Apply Aggregation For Measure Detail Filter To Query.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1095};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXLevelInfo queryProjLevelInfo = mdxQuery.getLevelInfo();
        for (IHierarchy hierarchy : queryProjLevelInfo.getHierarchyInfo().getProjectedHierarchies()) {
            if (hierarchy.getDimension().isMeasuresDimension()) continue;
            ILevel virtualCubeLowestLevel = queryProjLevelInfo.getLowestProjectedLevel(hierarchy);
            MDXLevelInfo virtualCubeLowestLevelInfo = new MDXLevelInfo();
            virtualCubeLowestLevelInfo.addProjectedHierarchy(virtualCubeLowestLevel);
            if (!DFSLAggrUtil.isAggrRequiredForVDF(mdxQuery, virtualCubeLowestLevelInfo)) continue;
            node.setPropertyValue("AggregationRequired", Boolean.TRUE);
            return;
        }
        node.setPropertyValue("AggregationRequired", Boolean.FALSE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("AggregationRequired") != null) {
            this.traceNodeCondition(false, "The AggregationRequired property has already been set on the target detail filter node.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The AggregationRequired property has not yet been set on the target detail filter node.", trace);
        return true;
    }
}

