/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeApplyMDFOnSingleHierarchyToSet;
import com.cognos.xqe.ast.olap.TNodeApplyORdMDFsOnDiffHiersToSet;
import com.cognos.xqe.ast.olap.TNodeApplyVDFToSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveDetailFilterTNodes
extends Transformation {
    public RemoveDetailFilterTNodes() {
        this.mName = "Remove Detail Filter Transformation Nodes.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1093, 1094, 1095, 1107};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        int i;
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (node.getType() == 1093 && node.getPropertyValue("DistributeMemberDFToPreMDXFilteringSetsApplied") != Boolean.TRUE) {
            this.traceNodeCondition(false, "The TNodeMDFOnSingleHierarchy node has not yet been distributed to all parts of the query.", trace);
            return false;
        }
        if (node.getType() == 1095 && node.getPropertyValue("DistributeVDFToPreMDXFilteringSets") != Boolean.TRUE) {
            this.traceNodeCondition(false, "The TNodeValueDetailFilter node has not yet been distributed to all parts of the query.", trace);
            return false;
        }
        if (node.getType() == 1107 && node.getPropertyValue("DistributeORdMDFsOnDiffHiersToPreMDXFilteringSetsApplied") != Boolean.TRUE) {
            this.traceNodeCondition(false, "The TNodeORdMDFsOnDiffHiers node has not yet been distributed to all parts of  the query.", trace);
            return false;
        }
        if (node.getPropertyValue("AggregationRequired") != Boolean.FALSE && (node.getPropertyValue("AggregationRequired") != Boolean.TRUE || node.getPropertyValue("AggregationApplied") != Boolean.TRUE)) {
            this.traceNodeCondition(false, "Aggregation for the target node has not yet been applied to the query.", trace);
            return false;
        }
        IXQEQueryNode[] tNodes = mdxQuery.getDescendantsOfType(1018, false);
        for (i = 0; i < tNodes.length; ++i) {
            if (((TNodeApplyMDFOnSingleHierarchyToSet)tNodes[i]).getDetailFilterIds().size() <= 0) continue;
            this.traceNodeCondition(false, "The query contains TNodeApplyMDFOnSingleHierarchyToSet nodes that have not yet been fully processed.", trace);
            return false;
        }
        tNodes = mdxQuery.getDescendantsOfType(1020, false);
        for (i = 0; i < tNodes.length; ++i) {
            if (((TNodeApplyVDFToSet)tNodes[i]).getDetailFilterIds().size() <= 0) continue;
            this.traceNodeCondition(false, "The query contains TNodeApplyVDFToSet nodes that have not yet been fully processed.", trace);
            return false;
        }
        tNodes = mdxQuery.getDescendantsOfType(1112, false);
        for (i = 0; i < tNodes.length; ++i) {
            if (((TNodeApplyORdMDFsOnDiffHiersToSet)tNodes[i]).getDetailFilterIds().size() <= 0) continue;
            this.traceNodeCondition(false, "The query contains TNodeApplyORdMDFsOnDiffHiersToSet nodes that have not yet been fully processed.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The node has been fully processed and can be removed.", trace);
        return true;
    }
}

