/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeAbstractMDXNode;
import com.cognos.xqe.ast.olap.TNodeApplyMDFOnSingleHierarchyToSet;
import com.cognos.xqe.ast.olap.TNodeApplyORdMDFsOnDiffHiersToSet;
import com.cognos.xqe.ast.olap.TNodeApplyVDFToSet;
import com.cognos.xqe.ast.olap.TNodeValueDetailFilter;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import java.util.List;

public final class RemoveTNodeApplyDetailFilter
extends Transformation {
    public RemoveTNodeApplyDetailFilter() {
        this.mName = "Remove TNodeApplyMDFOnSingleHierarchyToSet and TNodeApplyVDFToSet nodes.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1018, 1020, 1112};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IXQEQueryNode[] tNodeValueDetailFilters = mdxQuery.getChildrenOfType(1095);
        block0: for (int i = 0; i < tNodeValueDetailFilters.length; ++i) {
            List<Integer> tnIds = ((TNodeValueDetailFilter)tNodeValueDetailFilters[i]).getTNodeApplyVDFSetIds();
            for (Integer tnId : tnIds) {
                if (tnId != node.getId()) continue;
                tnIds.remove(tnId);
                continue block0;
            }
        }
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        List<TNodeAbstractMDXNode> valueDF = DFSLAggrUtil.getUnprocessedVDFs(mdxQuery);
        if (valueDF.size() > 0) {
            this.traceNodeCondition(false, "The node does have remaining value detail filters to be processed.", trace);
            return false;
        }
        switch (node.getType()) {
            case 1018: {
                if (((TNodeApplyMDFOnSingleHierarchyToSet)node).getDetailFilterIds().size() != 0) break;
                status = true;
                break;
            }
            case 1020: {
                if (((TNodeApplyVDFToSet)node).getDetailFilterIds().size() != 0) break;
                status = true;
                break;
            }
            case 1112: {
                if (((TNodeApplyORdMDFsOnDiffHiersToSet)node).getDetailFilterIds().size() != 0) break;
                status = true;
                break;
            }
        }
        if (status) {
            this.traceNodeCondition(status, "The node does not have any remaining filters to be processed.", trace);
        }
        this.traceNodeCondition(status, "The node has at least one remaining filter that must be processed..", trace);
        return status;
    }
}

