/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.application;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeAbstractMDXNode;
import com.cognos.xqe.ast.olap.TNodeApplyReaggregationToMeasure;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import java.util.List;
import java.util.Set;

public class SetReaggregationHostProperty
extends Transformation {
    public SetReaggregationHostProperty() {
        this.mName = "Set destination of location for a value detail filter.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{1095, 1093, 1193, 1094, 1098, 1097, 1185};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String vdfReaggregationLocation = null;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            node.throwInternalError("Unable to find the ancestor MDXQuery node.");
        }
        if (node.getType() == 1097 || node.getType() == 1185 || node.getType() == 1193 || node.getType() == 1094) {
            vdfReaggregationLocation = "reaggregationHostDimensionLine";
            node.setPropertyValue("reaggregationHost", vdfReaggregationLocation);
            return;
        }
        MDXDimensionLine dimLine = mdxQuery.getDimensionLine();
        if (dimLine != null && dimLine.getNumberChildren() == 1 && dimLine.getChild(0).isOfCategory(1068) && dimLine.getChild(0).getNumberChildren() > 0 && !mdxQuery.getDataSourceType().equals("PC")) {
            vdfReaggregationLocation = "reaggregationHostDimensionLine";
        }
        Set<IDimension> referencedDimensions = mdxQuery.getReferencedDimensions();
        List<IDimension> cubeDimensions = mdxQuery.getReferencedCube().getDimensions();
        if (vdfReaggregationLocation == null && cubeDimensions.size() - referencedDimensions.size() > 1) {
            vdfReaggregationLocation = "reaggregationHostDimensionLine";
        }
        if (vdfReaggregationLocation == null) {
            vdfReaggregationLocation = "reaggregationHostMeasure";
            IXQEQueryNode[] applyReaggregationToMeasureTNode = mdxQuery.getDescendantsOfType(1172, false);
            if (applyReaggregationToMeasureTNode.length > 1) {
                node.throwInternalError("There should be only one TNodeApplyReaggregationToMeasure node in query.");
            }
            TNodeApplyReaggregationToMeasure tnode = null;
            if (applyReaggregationToMeasureTNode.length == 0) {
                XQENodeFactory factory = environment.getNodeFactory();
                tnode = (TNodeApplyReaggregationToMeasure)factory.createNode(1172);
                mdxQuery.addChild(tnode);
            } else {
                tnode = (TNodeApplyReaggregationToMeasure)applyReaggregationToMeasureTNode[0];
            }
            tnode.registerDetailFilter((TNodeAbstractMDXNode)node);
        }
        node.setPropertyValue("reaggregationHost", vdfReaggregationLocation);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (DFSLAggrUtil.getReaggregationHostName((TNodeAbstractMDXNode)node) != null) {
            this.traceNodeCondition(false, "SetReaggregationHostProperty has been applied to the target detail filter or slicer.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the target TNodeValueDetailFilter node are invalid.", trace);
            return false;
        }
        if (node.isOfTypes(new int[]{1098, 1097, 1185, 1193})) {
            this.traceNodeCondition(true, "Reaggregation host property of the slicer can be set.", trace);
            return true;
        }
        if (node.getPropertyValue("AggregationRequired") == null) {
            this.traceNodeCondition(false, "The target detail filter node has not yet been flagged as necessitating aggregation in the query.", trace);
            return false;
        }
        if (node.getPropertyValue("AggregationRequired") == Boolean.FALSE) {
            this.traceNodeCondition(false, "The query does not require an aggregation for the target detail filter node.", trace);
            return false;
        }
        if (node.getPropertyValue("AggregationApplied") == Boolean.TRUE) {
            this.traceNodeCondition(false, "Aggregation has already been applied for the target detail filter node.", trace);
            return false;
        }
        int[] filterTypes = new int[]{1095, 1093, 1094};
        if (node.isOfTypes(filterTypes) && node.getNumberChildren() < 2) {
            this.traceNodeCondition(false, "Reaggregation set has not been built for the target detail filter node.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Reaggregation host property of the value detail filter can be set.", trace);
        return true;
    }
}

