/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.classification;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXSlicer;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeAbstractSlicer;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.classification.DFSLClassificationUtil;
import java.util.Set;

public final class CastToSlicerOnReferencedHierarchy
extends Transformation {
    public CastToSlicerOnReferencedHierarchy() {
        this.mName = "Cast To Slicer On Projected Hierarchy.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{1009};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        CogMDXSlicer cogMDXSlicer = (CogMDXSlicer)node;
        TNodeAbstractSlicer tNodeSlicer = (TNodeAbstractSlicer)factory.createNode(1185);
        tNodeSlicer.setOriginalExpression(cogMDXSlicer.getOriginalExpression());
        cogMDXSlicer.exchange(tNodeSlicer, true);
        MDXQuery mdxQuery = (MDXQuery)tNodeSlicer.getAncestorOfType(1002);
        AbstractMDXNode expression = (AbstractMDXNode)tNodeSlicer.getChild(0);
        mdxQuery.updateCountOfMDFandSlicerByHierarchy(expression.getHierarchyInfo().getProjectedHierarchy(0));
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The CogMDXSlicer node has invalid child nodes.", trace);
            return false;
        }
        MDXHierInfo hierInfo = ((AbstractMDXNode)node.getChild(0)).getHierarchyInfo();
        if (hierInfo.getNumProjectedHierarchies() != 1) {
            this.traceNodeCondition(false, "The first child of the CogMDXSlicer node does not project a single hierarchy.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IHierarchy hierarchy = hierInfo.getProjectedHierarchy(0);
        MDXHierInfo projectedHierarchies = mdxQuery.getHierarchyInfo();
        if (projectedHierarchies.projectsHierarchy(hierarchy)) {
            this.traceNodeCondition(false, "The CogMDXSlicer expression projects a hierarchy that is projected in one of the MDXEdge expressions of the MDXQuery.", trace);
            return false;
        }
        Set<IHierarchy> refHierarchies = mdxQuery.getReferencedHierarchiesOnEdges();
        if (refHierarchies.contains(hierarchy)) {
            this.traceNodeCondition(true, "The CogMDXSlicer expression projects a hierarchy that is referenced in one or more of the MDXEdge expressions of the MDXQuery.", trace);
            return true;
        }
        if (DFSLClassificationUtil.queryContainsVDFThatReferencesHierarchy(mdxQuery, hierarchy)) {
            this.traceNodeCondition(true, "The CogMDXSlicer expression projects a hierarchy that is referenced in one or more of the value comparison conditions in the detail filters in the MDXQuery.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The CogMDXSlicer expression does not project a hierarchy that is referenced in any of the MDXEdge expressions or VDF condition expressions in the MDXQuery.", trace);
        return false;
    }
}

