/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.Set;

public final class RemoveSlicerWhenNoMeasure
extends Transformation {
    public RemoveSlicerWhenNoMeasure() {
        this.mName = "Remove Slicer When No Measure.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{1098, 1097, 1185};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        node.throwOnInvalidChildCategories();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            node.throwInternalError("Internal Error.");
        }
        if (mdxQuery.getDataSourceType().equals("BW")) {
            MDXEdge[] mdxEdges = mdxQuery.getEdges();
            for (int idx = 0; idx < mdxEdges.length; ++idx) {
                MDXEdge mdxEdge = mdxEdges[idx];
                if (!mdxEdge.getMDXNonEmptyProperty()) continue;
                this.traceNodeCondition(false, "The provider type is SAP with NON EMPTY enabled on an edge.", trace);
                return false;
            }
        }
        if (mdxQuery.getHierarchyInfo().projectsMeasures()) {
            this.traceNodeCondition(false, "The ancestor MDXQuery node projects the measures dimension.", trace);
            return false;
        }
        Set<MDXHierInfo> veHierInfo = mdxQuery.getContextDependentValueExpressionHierarchyInfo(mdxQuery);
        if (!veHierInfo.isEmpty()) {
            this.traceNodeCondition(false, "The ancestor MDXQuery contains a value expression dependent on the slicer.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The slicer can be removed as no values are dependent on it.", trace);
        return true;
    }
}

