/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeAbstractSlicer;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.Set;

public final class RemoveSlicerWhenSetProjected
extends Transformation {
    public RemoveSlicerWhenSetProjected() {
        this.mName = "Replace Slicer When Set Projected.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{1098};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        node.throwOnInvalidChildCategories();
        IHierarchy hierarchy = ((TNodeAbstractSlicer)node).getHierarchy();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            node.throwInternalError("Internal Error.");
        }
        IXQEQueryNode slicerSet = node.getChild(0);
        MDXEdge[] edges = mdxQuery.getEdges();
        boolean applyTransformatin = false;
        for (MDXEdge edge : edges) {
            Set<IHierarchy> hierarchies;
            IXQEQueryNode[] groups;
            boolean setProjected = false;
            for (IXQEQueryNode group : groups = edge.getDescendantsOfTypes(new int[]{1027, 1026}, false)) {
                IXQEQueryNode[] ancestorGroups;
                ((AbstractMDXNode)group).throwOnInvalidChildCategories();
                AbstractMDXSet groupSet = (AbstractMDXSet)group.getChild(0);
                if (!groupSet.getHierarchyInfo().projectsHierarchy(hierarchy)) continue;
                if (!(groupSet.isSameExpression(slicerSet, false) || groupSet.getType() == 1039 && groupSet.getNumberChildren() == 1 && groupSet.getChild(0).isSameExpression(slicerSet, false))) {
                    this.traceNodeCondition(false, "The slicer is not the only set from this hierarchy projected.", trace);
                    return false;
                }
                if (group.getNumberChildren() > 1) {
                    Set<MDXHierInfo> veHierInfo;
                    Set<IHierarchy> hierarchies2 = ((AbstractMDXNode)group.getChild(1)).getReferencedHierarchies();
                    if (hierarchies2.contains(hierarchy)) {
                        this.traceNodeCondition(false, "The slicer hierarchy is referenced from more than one group.", trace);
                        return false;
                    }
                    if (group.getType() == 1026 && !(veHierInfo = ((AbstractMDXNode)group.getChild(1)).getContextDependentValueExpressionHierarchyInfo(mdxQuery)).isEmpty()) {
                        this.traceNodeCondition(false, "A value expression from a CogMDXNest node is dependent on the slicer.", trace);
                        return false;
                    }
                }
                for (IXQEQueryNode ancestorGroup : ancestorGroups = group.getAncestorsOfType(1027)) {
                    ((AbstractMDXNode)ancestorGroup).throwOnInvalidChildCategories();
                    Set<IHierarchy> hierarchies3 = ((AbstractMDXNode)ancestorGroup.getChild(0)).getReferencedHierarchies();
                    if (hierarchies3.contains(hierarchy)) {
                        this.traceNodeCondition(false, "The slicer hierarchy is referenced from an ancestor group.", trace);
                        return false;
                    }
                    Set<MDXHierInfo> veHierInfo = ((AbstractMDXNode)ancestorGroup.getChild(0)).getContextDependentValueExpressionHierarchyInfo(mdxQuery);
                    if (veHierInfo.isEmpty()) continue;
                    this.traceNodeCondition(false, "A value expression is dependent on the slicer.", trace);
                    return false;
                }
                applyTransformatin = true;
                setProjected = true;
            }
            if (setProjected || !(hierarchies = edge.getReferencedHierarchies()).contains(hierarchy)) continue;
            this.traceNodeCondition(false, "The slicer hierarchy is referenced from an edge.", trace);
            return false;
        }
        if (applyTransformatin) {
            this.traceNodeCondition(true, "The slicer can be removed.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The slicer is not projected and cannot be removed.", trace);
        return false;
    }
}

