/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.slicer_detailfilter.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.MDXAnd;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class DecomposeANDDetailFilter
extends Transformation {
    public DecomposeANDDetailFilter() {
        this.mName = "Decompose AND Detail Filter";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{1010};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXDetailFilter cogMDXDetailFilter = (CogMDXDetailFilter)node;
        XQENodeFactory factory = environment.getNodeFactory();
        CogMDXDetailFilter newCogMDXDetailFilterNode = (CogMDXDetailFilter)factory.createNode(1010);
        boolean postAggregation = cogMDXDetailFilter.getPostAutoAggregation();
        boolean masterDetailFilter = cogMDXDetailFilter.isMasterDetailFilter();
        String masterDetailFilterDescription = cogMDXDetailFilter.getMasterDetailLinkDescription();
        newCogMDXDetailFilterNode.setPostAutoAggregation(postAggregation);
        newCogMDXDetailFilterNode.setMasterDetailFilter(masterDetailFilter);
        newCogMDXDetailFilterNode.setMasterDetailLinkDescription(masterDetailFilterDescription);
        newCogMDXDetailFilterNode.setOriginalExpression(cogMDXDetailFilter.getOriginalExpression());
        MDXQuery mdQuerySpec = (MDXQuery)cogMDXDetailFilter.getAncestorOfType(1002);
        mdQuerySpec.addChild(newCogMDXDetailFilterNode);
        IXQEQueryNode andNode = cogMDXDetailFilter.getChild(0);
        newCogMDXDetailFilterNode.addChild(andNode.detachChild(1));
        String timing = (String)cogMDXDetailFilter.getPropertyValue("timing");
        if (timing != null) {
            newCogMDXDetailFilterNode.setPropertyValue("timing", timing);
        }
        andNode.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the CogMDXDetailFilter node are invalid.", trace);
            return false;
        }
        if (node.getChild(0).getType() != 1110) {
            this.traceNodeCondition(false, "The child of the CogMDXDetailFilter node is not an MDXAnd node.", trace);
            return false;
        }
        MDXAnd andNode = (MDXAnd)node.getChild(0);
        if (!andNode.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the MDXAnd node are invalid.", trace);
            return false;
        }
        if (andNode.isConditionsOnValueExpressions()) {
            this.traceNodeCondition(false, "The target node is an MDXAnd condition that is comprised entirely of sub-conditions on value expressions.  It does not need to be decomposed.", trace);
            return false;
        }
        if (andNode.isOperandRepeated(andNode.getChild(0))) {
            this.traceNodeCondition(false, "The ApplyIdempotentLaws transformation should be applied to the first MDXAnd operand.", trace);
            return false;
        }
        if (andNode.isOperandRedundant(andNode.getChild(1))) {
            this.traceNodeCondition(false, "The ApplyIdempotentLaws transformation should be applied to the second MDXAnd operand.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The CogMDXDetailFilter condition can be decomposed.", trace);
        return true;
    }
}

